//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "Flickr_Upload.h"
#import "FlickrSignature.h"
#import "PUCommon.h"
#import "FLPhoto.h"
#import "NSXMLElement-ex.h"

@implementation Flickr_Upload

-(id) init
{
	if (self = [super initWithBasePath:@"http://api.flickr.com/services/upload/" withArgs:nil needSignature:NO method:@"POST"]) {
	}
	return self;
}

-(void) start
{
	NSURL* fileUrl			= [self valueForKeyPath:@"param.fileUrl"];
	NSString* title			= [self valueForKeyPath:@"param.title"];
	NSString* contentType	= [self valueForKeyPath:@"param.contentType"];	
	NSString* comment		= [self valueForKeyPath:@"param.comment"];	
	NSArray* keyword		= [self valueForKeyPath:@"param.keyword"];	
	
	if (!(fileUrl && [fileUrl isFileURL] && contentType)) {
		return;
	}
	
	[m_postData setObject:[FlickrSignature apiKey] forKey:@"api_key"];
	[m_postData setObject:[FlickrRequest token] forKey:@"auth_token"];
	
	if (!IS_NULL_STR(title)) {
		[m_postData setObject:title forKey:@"title"];
	}
	if (keyword && [keyword count] > 0) {
		[m_postData setObject:[keyword componentsJoinedByString:@" "] forKey:@"tags"];
	}
	if (!IS_NULL_STR(comment)) {
		[m_postData setObject:comment forKey:@"description"];
	}

	// photo以外のすべてのパラメータについてのsignatureを算出する
	[m_postData setObject:[FlickrSignature generateApiSignature:m_postData] forKey:@"api_sig"];

	[m_postData setObject:[NSDictionary dictionaryWithObjectsAndKeys:
						   fileUrl,		KEY_URL,
						   contentType,	KEY_TYPE,
						   nil]
				   forKey:@"photo"];	
	
	[super start];
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		id photoId = [[xml rootElement] objectValueForXPath:@"/rsp/photoid" error:&err];
		if (!err) {
			if (photoId) {
				FLPhoto* photo = [[FLPhoto alloc] init];
				[photo setValue:photoId forKey:@"photoid"];
				*error = nil;
				return [photo autorelease];
			} else {
				*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];				
			}
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];		
	}
	return nil;
}

@end
