//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import <Cocoa/Cocoa.h>


@interface NSXMLElement (PhotoUploader)

/**
 @brief	XPathにしたがう唯一のnodeを取得
 @return	複数あればnil
 */
-(id) nodeForXPath:(NSString*)xpath error:(NSError**)error;

/**
 @brief	XPathにしたがう唯一のnodeの属性を全取得
 @return	nodeが複数あればnil
 */
-(NSArray*) attributesForXPath:(NSString*)xpath error:(NSError**)error;

/**
 @brief	XPathにしたがう唯一のnodeのname属性値を取得
 @return	nodeが複数あればnil
 */
-(id) attributeValueForXPath:(NSString*)xpath andName:(NSString*)name error:(NSError**)error;

/**
 @brief	XPathにしたがう唯一のnodeの中身を取得
 @return	nodeが複数あればnil
 */
-(NSString*) objectValueForXPath:(NSString*)xpath error:(NSError**)error;

/**
 @brief	属性値を取得
 */
-(NSString*) attributeValueForName:(NSString*)name;

/**
 @brief	属性設定
 @note	すでにあれば上書き <- ここがaddAttributeとちがう
 */
-(void) setAttribute:(NSXMLNode*)attribute;

-(void) setAttributeValue:(NSString*)value forName:(NSString*)name;


@end
