//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "PUPhoto.h"
#import "ExportMgr.h"

@implementation PUPhoto

+(NSArray*) photosWithExManager:(id)mgr
{
	NSMutableArray* photos = [NSMutableArray array];
	PUPhoto* photo;
	int i;
	for (i = 0; i < [mgr imageCount]; i++) {
		photo = [[PUPhoto alloc] init];
		
		[photo setValue:[mgr imagePathAtIndex:i] forKey:@"path"];
		if ([mgr respondsToSelector:@selector(imageCaptionAtIndex:)]) {
			// iPhoto v5
			[photo setValue:[mgr imageCaptionAtIndex:i] forKey:@"title"];	
		} else if ([mgr respondsToSelector:@selector(imageTitleAtIndex:)]) {
			// iPhoto v7
			[photo setValue:[mgr imageTitleAtIndex:i] forKey:@"title"];
		}
		[photo setValue:[mgr imageCommentsAtIndex:i] forKey:@"comment"];
		[photo setValue:[mgr imageKeywordsAtIndex:i] forKey:@"keyword"];
		[photos addObject:photo];
		[photo release];
	}
	return photos;
}

@end
