//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import <Cocoa/Cocoa.h>

typedef enum {
	kPUImageFormat_Invalid = -1,

	kPUImageFormat_Jpeg = 0,
	kPUImageFormat_Png,
	kPUImageFormat_Gif,
	kPUImageFormat_Other = 1000,
	kPUImageFormat_Original = 2000,
} PUImageFormat;

typedef enum {
	kPUImageSize_Invalid = -1,
	
	kPUImageSize_SS	= 0,
	kPUImageSize_S	= 1,
	kPUImageSize_M	= 2,
	kPUImageSize_L	= 3,
	kPUImageSize_LL	= 4,

	kPUImageSize_Original = 1000,
} PUImageSize;

@interface PUImageProcessor : NSObject {

}

/**
 *	ファイルの画像フォーマット検出
 */
+(PUImageFormat) formatWithPath:(NSString*)path;

/**
 *	フォーマット文字列からフォーマット値ヘ変換
 */
+(PUImageFormat) formatFromString:(NSString*)str;

/**
 *	フォーマットからフォーマット文字列へ変換
 */
+(NSString*) stringFromFormat:(PUImageFormat)format;

/**
 *	画像変換
 */
+(BOOL) convertImage:(NSString*)origPath toPath:(NSString*)toPath format:(PUImageFormat)format size:(PUImageSize)size;

@end
