/*
 *  ExportImageProtocol.h
 *  iPhotoZou
 *
 *  Created by itok on 08/01/14.
 *  Copyright 2008 itok. All rights reserved.
 *
 */

@protocol ExportImageProtocol
- (unsigned int)imageCount;
- (struct _NSSize)imageSizeAtIndex:(unsigned int)fp8;
- (unsigned long)imageFormatAtIndex:(unsigned int)fp8;
- (unsigned long)originalImageFormatAtIndex:(unsigned int)fp8;
- (BOOL)originalIsRawAtIndex:(unsigned int)fp8;
- (BOOL)originalIsMovieAtIndex:(unsigned int)fp8;
- (id)imageTitleAtIndex:(unsigned int)fp8;
- (id)imageCommentsAtIndex:(unsigned int)fp8;
- (float)imageRotationAtIndex:(unsigned int)fp8;
- (id)imagePathAtIndex:(unsigned int)fp8;
- (id)sourcePathAtIndex:(unsigned int)fp8;
- (id)thumbnailPathAtIndex:(unsigned int)fp8;
- (id)imageFileNameAtIndex:(unsigned int)fp8;
- (BOOL)imageIsEditedAtIndex:(unsigned int)fp8;
- (BOOL)imageIsPortraitAtIndex:(unsigned int)fp8;
- (float)imageAspectRatioAtIndex:(unsigned int)fp8;
- (unsigned long long)imageFileSizeAtIndex:(unsigned int)fp8;
- (id)imageDateAtIndex:(unsigned int)fp8;
- (int)imageRatingAtIndex:(unsigned int)fp8;
- (id)imageTiffPropertiesAtIndex:(unsigned int)fp8;
- (id)imageExifPropertiesAtIndex:(unsigned int)fp8;
- (id)imageKeywordsAtIndex:(unsigned int)fp8;
- (id)albumsOfImageAtIndex:(unsigned int)fp8;
- (id)getExtensionForImageFormat:(unsigned long)fp8;
- (unsigned long)getImageFormatForExtension:(id)fp8;
- (unsigned int)albumCount;
- (id)albumNameAtIndex:(unsigned int)fp8;
- (id)albumMusicPathAtIndex:(unsigned int)fp8;
- (id)albumCommentsAtIndex:(unsigned int)fp8;
- (unsigned int)positionOfImageAtIndex:(unsigned int)fp8 inAlbum:(unsigned int)fp12;
- (id)window;
- (void)enableControls;
- (void)disableControls;
- (void)clickExport;
- (void)startExport;
- (void)cancelExportBeforeBeginning;
- (id)directoryPath;
- (unsigned int)sessionID;
- (BOOL)exportImageAtIndex:(unsigned int)fp8 dest:(id)fp12 options:(void *)fp16;
- (struct _NSSize)lastExportedImageSize;
@end
