#include "status.h"
#include <pthread.h>

typedef struct {
    int val;
    pthread_rwlock_t lock;
} status_t;

static status_t play = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t record = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t pause = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t opcr_channel = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t ipcr_channel = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t forward = {0, PTHREAD_RWLOCK_INITIALIZER};
static status_t debug = {0, PTHREAD_RWLOCK_INITIALIZER};

static pthread_mutex_t pause_control = PTHREAD_MUTEX_INITIALIZER;

static int getStatus(status_t *s) {
    int ret;
    pthread_rwlock_rdlock(&s->lock);
    ret = s->val;
    pthread_rwlock_unlock(&s->lock);
    return ret;
}

int isPlaying() {
    return getStatus(&play);
}

int isRecording() {
    return getStatus(&record);
}

int isPaused() {
    return getStatus(&pause);
}

int isDebug() {
    return getStatus(&debug);
}

int get_oPCR() {
    return getStatus(&opcr_channel);
}

int get_iPCR() {
    return getStatus(&ipcr_channel);
}

pthread_mutex_t *getPauseControl() {
    return &pause_control;
}

int getForward() {
    return getStatus(&forward);
}

static void setStatus(status_t *s, int value) {
    pthread_rwlock_wrlock(&s->lock);
    s->val = value;
    pthread_rwlock_unlock(&s->lock);
}

void setPlaying() {
    setStatus(&play, 1);
}

void setRecording() {
    setStatus(&record, 1);
}

void setPaused() {
    if(!isPaused())
        pthread_mutex_lock(&pause_control);
    setStatus(&pause, 1);
}

void setDebug() {
    setStatus(&debug, 1);
}

void set_oPCR(int channel) {
    setStatus(&opcr_channel, channel);
}

void set_iPCR(int channel) {
    setStatus(&ipcr_channel, channel);
}

void setForward() {
    setStatus(&forward, getForward() + 1);
}

void unsetPlaying() {
    setStatus(&play, 0);
}

void unsetRecording() {
    setStatus(&record, 0);
}

void unsetPaused() {
    if(isPaused())
        pthread_mutex_unlock(&pause_control);
    setStatus(&pause, 0);
}

void unsetForward() {
    setStatus(&forward, 0);
}

void unsetDebug() {
    setStatus(&debug, 0);
}
