#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "playlist.h"

playlist_t pl = {NULL, NULL};

node_t *createNode(char *filename, node_t *prev) {
    node_t *ret;
    ret = (node_t *)malloc(sizeof(node_t));
    
    int len = strlen(filename);
    ret->filename = (char *)malloc((sizeof(char) * len) + 1);
    strcpy(ret->filename, filename);
    ret->prev = prev;
    ret->next = NULL;

    return ret;
}

void addNode(char *filename, node_t *prev, node_t **target) {
    if(*target == NULL)
        *target = createNode(filename, prev);
    else
        addNode(filename, *target, &((*target)->next));
}

int initPlaylistFromFile(FILE *fpp) {
    int n = 0;
    char str[MAX_STR_LEN];

    pl.fpp = fpp;

    while(fgets(str, MAX_STR_LEN, fpp) != NULL) {
        char *p;
        
        p = strchr(str, '\n');
        if(p != NULL)
            *p = '\0';
        else
            continue;

        addNode(str, NULL, &pl.cur);
        n++;
    }

    return n;
}

int initPlaylistFromArg(char **argv) {
    int n;

    pl.fpp = NULL;

    for(n = 1; argv[n] != NULL; n++)
        addNode(argv[n], NULL, &pl.cur);

    return n - 1;
}

char *getCurrentFile(void) {
    return pl.cur->filename;
}

void setNextFile(void) {
    if(pl.cur->next != NULL) {
        pl.cur = pl.cur->next;
        printf("set to %s\n", pl.cur->filename);
    }
}

void setPrevFile(void) {
    if(pl.cur->prev != NULL) {
        pl.cur = pl.cur->prev;
        printf("set to %s\n", pl.cur->filename);
    }
}

void printNode(node_t *this) {
    if(this != NULL) {
        printf("this = %p\tprev = %p, filename = \"%s\", next = %p\n", this, this->prev, this->filename, this->next);
        printNode(this->next);
    }
}

void checkPlaylist(void) {
    printNode(pl.cur);
}

