/*
 * libiec61883 - Linux IEEE 1394 streaming media library.
 * Copyright (C) 2004 Dan Dennedy
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <sys/select.h>
#include <unistd.h>
#include <assert.h>

#include "mpeg2.h"
#include "status.h"
#include "playlist.h"

static int write_packet (unsigned char *data, int len, unsigned int dropped, void *callback_data)
{
    FILE *f = (FILE*) callback_data;

    if (dropped)
        fprintf (stderr, "\a%d packets dropped!\n", dropped);
    return (fwrite (data, len, 1, f) < 1) ? -1 : 0;
}

void mpeg2_receive (raw1394handle_t handle, FILE *f, int channel)
{
    
    iec61883_mpeg2_t mpeg = iec61883_mpeg2_recv_init (handle, write_packet,
        (void *)f );
    
    if ( mpeg && iec61883_mpeg2_recv_start (mpeg, channel) == 0)
    {
        int fd = raw1394_get_fd (handle);
        struct timeval tv;
        fd_set rfds;
        int result = 0;
        
        fprintf (stderr, "Starting to receive\n");

        do {
            FD_ZERO (&rfds);
            FD_SET (fd, &rfds);
            tv.tv_sec = 0;
            tv.tv_usec = 20000;
            
            if (select (fd + 1, &rfds, NULL, NULL, &tv) > 0)
                result = raw1394_loop_iterate (handle);
            
        } while (m_done == 0 && result == 0);
        
        fprintf (stderr, "done.\n");
    }
    iec61883_mpeg2_close (mpeg);
}
/*
void *mpeg2_transmit_new (void *t)
{    
    raw1394handle_t handle = raw1394_new_handle_on_port(0);
    if(handle == NULL) {
        fprintf(stderr, "%s handling error!\n", __FUNCTION__);
        return NULL;
    }

    buffer_t ts;
    int pid = initBuffer(&ts, );
    
    
    printf("pcr pid=%02x\n",pid);
    int bandwidth = -1;
    int oplug = -1, iplug = -1;
    int channel=0;
    unsigned int node = 0xffc0 | 0;
    int retry = 5;

    channel = iec61883_cmp_connect (handle, raw1394_get_local_id (handle),
                                    &oplug, node, &iplug, &bandwidth);
    printf("channel = %d\n",channel);
    while((channel < 0 || channel == 63) && retry > 0) {
        sleep(1);
        iec61883_cmp_disconnect(handle, raw1394_get_local_id(handle),
                                oplug, node, iplug, channel, bandwidth);
        raw1394_destroy_handle(handle);
        sleep(1);
        handle = raw1394_new_handle_on_port(0);
        channel = iec61883_cmp_connect (handle, raw1394_get_local_id (handle),
                                        &oplug, node, &iplug, &bandwidth);
        printf("channel = %d\n",channel);
        retry--;
        if(retry <= 0)
            goto LAST;
    }

    pthread_create(&p, NULL, fillBuffer, &buf);
    setPlaying();
    iec61883_mpeg2_t mpeg;
    
    mpeg = iec61883_mpeg2_xmit_init (handle, readBuffer, (void *)&buf );
    m_done = 0;
    if ( mpeg && iec61883_mpeg2_xmit_start (mpeg, pid, channel) == 0)
    {
        int fd = raw1394_get_fd (handle);
        struct timeval tv;
        fd_set rfds;
        int result = 0;
        
        fprintf (stderr, "Starting to transmit\n");
        
        do {
            FD_ZERO (&rfds);
            FD_SET (fd, &rfds);
            tv.tv_sec = 0;
            tv.tv_usec = 20000;
            
            if (select (fd + 1, &rfds, NULL, NULL, &tv) > 0)
                result = raw1394_loop_iterate (handle);

        } while (m_done == 0 && result == 0 && isPlaying());
        
        fprintf (stderr, "done.\n");
    }
    iec61883_mpeg2_close (mpeg);
    pthread_join(p, NULL);
LAST:
    fseeko(buf.fp, 0, SEEK_SET);
    int c = iec61883_cmp_disconnect(handle, raw1394_get_local_id(handle),
                                    oplug, node, iplug, channel, bandwidth);
    printf("cancel status = %d\n",c);
    raw1394_destroy_handle(handle);
    freeBuffer(&buf);
    
    unsetPlaying();
    return NULL;
}
*/
void *mpeg2_transmit (void *t)
{    
    raw1394handle_t handle = raw1394_new_handle_on_port(0);
    pthread_t p;
    char *filename = getCurrentFile();
    FILE *fp = fopen(filename, "rb");
    assert(fp != NULL);
    buffer_t buf;
    int pid = initBuffer(&buf, fp);
    
    
    printf("pcr pid=%02x\n",pid);
    int bandwidth = 0;
    int oplug = -1, iplug = get_iPCR();
    iplug = -1;
    int channel=0;
    unsigned int node = 0xffc0 | 0;
    int retry = 5;

    channel = iec61883_cmp_connect (handle, raw1394_get_local_id (handle),
                                    &oplug, node, &iplug, &bandwidth);
    printf("channel = %d\n",channel);
    while((channel < 0 || channel == 63) && retry > 0) {
        sleep(1);
        iec61883_cmp_disconnect(handle, raw1394_get_local_id(handle),
                                oplug, node, iplug, channel, bandwidth);
        raw1394_destroy_handle(handle);
        sleep(1);
        handle = raw1394_new_handle_on_port(0);
        channel = iec61883_cmp_connect (handle, raw1394_get_local_id (handle),
                                        &oplug, node, &iplug, &bandwidth);
        printf("channel = %d\n",channel);
        retry--;
        if(retry <= 0)
            goto LAST;
    }

    pthread_create(&p, NULL, fillBuffer, &buf);
    setPlaying();
    iec61883_mpeg2_t mpeg;
    
    mpeg = iec61883_mpeg2_xmit_init (handle, readBuffer, (void *)&buf );
    if(mpeg)
        iec61883_mpeg2_set_speed(mpeg, RAW1394_ISO_SPEED_400);
    m_done = 0;
    if ( mpeg && iec61883_mpeg2_xmit_start (mpeg, pid, channel) == 0)
    {
        int fd = raw1394_get_fd (handle);
        struct timeval tv;
        fd_set rfds;
        int result = 0;
        
        fprintf (stderr, "Starting to transmit\n");
        
        do {
            FD_ZERO (&rfds);
            FD_SET (fd, &rfds);
            tv.tv_sec = 0;
            tv.tv_usec = 20000;
            
            if (select (fd + 1, &rfds, NULL, NULL, &tv) > 0)
                result = raw1394_loop_iterate (handle);

        } while (m_done == 0 && isPlaying());
        
        fprintf (stderr, "done. m_done = %d result = %d\n", m_done, result);
    }
    iec61883_mpeg2_close (mpeg);
    pthread_join(p, NULL);
LAST:
    fseeko(buf.fp, 0, SEEK_SET);
    int c = iec61883_cmp_disconnect(handle, raw1394_get_local_id(handle),
                                    oplug, node, iplug, channel, bandwidth);
    printf("cancel status = %d\n",c);
    raw1394_destroy_handle(handle);
    freeBuffer(&buf);
    
    unsetPlaying();
    return NULL;
}

