/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Util;

public final class MethodImplCache {
    public final IPersistentMap protocol;
    public final Keyword methodk;
    public final int shift;
    public final int mask;
    public final Object[] table;
    volatile Entry mre = null;

    public MethodImplCache(IPersistentMap protocol, Keyword methodk) {
        this(protocol, methodk, 0, 0, RT.EMPTY_ARRAY);
    }

    public MethodImplCache(IPersistentMap protocol, Keyword methodk, int shift, int mask, Object[] table) {
        this.protocol = protocol;
        this.methodk = methodk;
        this.shift = shift;
        this.mask = mask;
        this.table = table;
    }

    public IFn fnFor(Class c) {
        Entry last2 = this.mre;
        if (last2 != null && last2.c == c) {
            return last2.fn;
        }
        return this.findFnFor(c);
    }

    IFn findFnFor(Class c) {
        int idx = (Util.hash(c) >> this.shift & this.mask) << 1;
        if (idx < this.table.length && this.table[idx] == c) {
            Entry e2;
            this.mre = e2 = (Entry)this.table[idx + 1];
            return e2 != null ? e2.fn : null;
        }
        return null;
    }

    public static class Entry {
        public final Class c;
        public final IFn fn;

        public Entry(Class c, IFn fn2) {
            this.c = c;
            this.fn = fn2;
        }
    }
}

