#!/usr/bin/env python

from htmltree import htmltree
import sys
import re

try:
    input = sys.argv[1]
except IndexError:
    sys.exit("%s <input_html>" % sys.argv[0])

f = open(input, "r")
html_text = f.read()
f.close()

t = htmltree.HTMLTree()
t.parse(html_text)

r = t.root()

titles = r.select_by_name2("head", "title")
if len(titles) > 0:
    for title in titles:
        for item in title:
            print item
            print item.text()

rn = htmltree.HTMLRenderer()
print rn.render(r)

t = r.get_element_by_id("htmltree")
print t.inner_html()

t = r.get_element_by_id("header1")
print t.inner_html()

t = r.select_1st("#header1")
print t.inner_html()

print "test_remove"
attrs = {
    "rel": "stylesheet",
    "type": "text/css",
    "href": "main.css"
    }
elems = r.get_elements("link", attrs)
for elem in elems:
    elem.delete()
print r.inner_html()

t = r.select_1st("#htmltree")
t.delete()
print r.inner_html()

