// テンプレートの読み込み
var express = require('express');
var ejs = require('ejs');

// サーバの作成
var app = express.createServer();

// expressがPOSTパラメータを処理するための指定
app.use(express.bodyDecoder());

// app.render('*.ejs')はejsテンプレートエンジンで処理させる
app.register('.ejs', ejs);

// '/'のリクエストハンドラ
app.get('/', function(req, res) {
    // index.html を読み込んで表示
    res.render('index.ejs');
});

// POST
app.post('/', function(req, res) {
    // req.bodyにPOSTパラメータがセットされるのでそのままテンプレートに渡す
    res.render('result.ejs', {
        locals: {message: req.body.url}
    });
});

// サーバを起動
app.listen(80, '127.0.0.1');
