////////////////////////////////////////////////////////////////////////////////
//
// 設定
//
////////////////////////////////////////////////////////////////////////////////

// ポート番号
var port = 80;

// MySQL データベース名、ユーザ名、パスワード
var DB_NAME = "test";
var DB_USER = "app_user";
var DB_PASSWD = "app";

// モジュールの読み込み
var express = require("express")
  , ejs = require("ejs")
  , io = require("socket.io")
  , sys = require("sys")
  , Client = require("mysql").Client;
  
// サーバを作成
var app = express.createServer();

// 静的ファイルのフォルダ
app.configure(function(){
	app.use(express.staticProvider(__dirname + "/public"));
});
// ejsテンプレートを利用する
app.set("view engine", "ejs");
// レイアウトを利用しない
app.set("view options", {layout: false});

// MySQLデータベースに接続しcallbackを呼び出す
function mysql(callback) {
	var client = new Client();
	client.database = DB_NAME;
	client.user = DB_USER;
	client.password = DB_PASSWD;

	client.connect(function(err) {
		if (err) {
			throw err;
		}
		callback(client);
	});
}

////////////////////////////////////////////////////////////////////////////////
//
// HTTP
//
////////////////////////////////////////////////////////////////////////////////

// GETリクエストを受け取る
app.get("/", function(req, res){
	console.log("/");
	res.render("index", {locals: {port: port}});
});

// サーバを起動する
app.listen(port);

////////////////////////////////////////////////////////////////////////////////
//
// WebSocket
//
////////////////////////////////////////////////////////////////////////////////

// WebSocketを起動する
var io = io.listen(app)
  , buffer = [];
  
// クライアントの接続時
io.on('connection', function(client){

	// クライアントに今までのメッセージ履歴（バッファ）を送信する
	client.send({ buffer: buffer });
	// 他のクライアントに接続通知メッセージを送信する
	client.broadcast({ announcement: client.sessionId + ' connected' });

	// クライアントからの受信時
	client.on('message', function(message){
		var msg = { message: [client.sessionId, message] };
		// メッセージをバッファに追加
		buffer.push(msg);
		// バッファは15以上になったら切り捨てる
		if (buffer.length > 15) buffer.shift();
		// 他のクライアントに配信
		client.broadcast(msg);
	
		// mysql 実行（メッセージの登録）
		mysql(function(mysql_client) {
			mysql_client.query(
			   "INSERT INTO chat_history (user_id, message) VALUES (?, ?)",
			   [client.sessionId, message],
			   function(err, results) {
					if (err) {
						mysql_client.end();
						throw err;
					}
					if (!err) {
						mysql_client.end();
					}
				 }
			 );
		});
	});

	// クライアントの切断時
	client.on('disconnect', function(){
		// 他のクライアントに切断通知メッセージを送信する
		client.broadcast({ announcement: client.sessionId + ' disconnected' });
	});
});
