#!/bin/sh

if [ "$1" = "" ]; then
    echo "Usage: $0 <*.o ...>"
    exit 1
fi

gcov -b $* | gawk '
BEGIN {
    total = 0;
}
$1 == "File" {
    fname = $1
    next
}
/^Lines/ {
    split($0, a, /[ :%]*/)
    ltotal += a[5]
    lexec += int(a[5]*a[3]/100)
}
/^Branches/ {
    split($0, a, /[ :%]*/)
    btotal += a[5]
    bexec += int(a[5]*a[3]/100)
}
/^Taken/ {
    split($0, a, /[ :%]*/)
    ttotal += a[7]
    texec += int(a[7]*a[5]/100)
}
/^Calls/ {
    split($0, a, /[ :%]*/)
    ctotal += a[5]
    cexec += int(a[5]*a[3]/100)
}
END {
    printf "   lines: %3d of %4d (% 3d%%)\n", lexec, ltotal, lexec*100/ltotal
    printf "branches: %3d of %4d (% 3d%%)\n", bexec, btotal, bexec*100/btotal
    printf "   taken: %3d of %4d (% 3d%%)\n", texec, ttotal, texec*100/ttotal
    printf "   calls: %3d of %4d (% 3d%%)\n", cexec, ctotal, cexec*100/ctotal
}
'


