#include "htlib2.h"
#include "Time.h"

clock_t
G(GetSystemClock)()
{
#ifdef __linux__
	return times(NULL);
#else
	struct tms t;
	return times(&t);
#endif
}

static int s_cps = 0;

int
G(DiffClockMillis)(clock_t to, clock_t from)
{
	if (s_cps == 0) {
		s_cps = sysconf(_SC_CLK_TCK);
	}
	return (int)(to - from)*1000/s_cps;
}

int
G(GetElapsedMillis)(clock_t from)
{
	return G(DiffClockMillis)(G(GetSystemClock)(), from);
}

#ifdef TEST

int
main()
{
	clock_t base = G(GetSystemClock)();
	int i;
	for (i=0; i<5; i++) {
		sleep(1);
		clock_t now = G(GetSystemClock)();
		printf("time=%d...\n", G(DiffClockMillis)(now, base));
	}
	return 0;
}

#endif
