package com.interpress_project.modernshare.ipcommon;

import java.text.DecimalFormat;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * @stereotype Singleton factory
 */
public class SystemBase {
	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Singleton
	 * @supplierRole Singleton factory
	 */
	/*# private SystemBase _systemBase; */
	private static SystemBase instance = null;

	/** @link dependency
	 * @stereotype creates
	 */
	/*# SystemUtilImpl lnkSystemUtilImpl; */
	private static Logger logger = null;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private static SystemUtilImpl utilImpl = null;

	/**
	 * System constants
	 */
	private String userHome;
	private String fileSeparator;
	private String lineSeparator;
	private String pathSeparator;
	private String tmpDir;
	private String currDir;
	private String osName;

	/**
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 */
	private DateUtilImpl dateUtilImpl;

	/**
	 * SystemBase
	 */
	protected SystemBase() {
		Properties prop = System.getProperties();

		userHome = prop.getProperty("user.home");
		currDir = prop.getProperty("user.dir");
		fileSeparator = prop.getProperty("file.separator");
		lineSeparator = prop.getProperty("line.separator");
		pathSeparator = prop.getProperty("path.separator");
		tmpDir = prop.getProperty("java.io.tmpdir");
		osName = prop.getProperty("os.name").toUpperCase();
	}

	/**
	 * getInstance
	 * @return SystemBase
	 */
	public static synchronized SystemBase getInstance() {
		if (instance == null) {
			instance = new SystemBase();
		}
		return instance;
	}

	/**
	 * setLoggerInfo
	 * @param loggerName String
	 * @param propFileName String
	 */
	public void setLoggerInfo(String loggerName, String propFileName) {
		PropertyConfigurator.configure(propFileName);
		logger = Logger.getLogger(loggerName);
	}

	/**
	 * getFileSeparator
	 * @return java.lang.String
	 */
	public String getFileSeparator() {
		return this.fileSeparator;
	}

	/**
	 * getLineSeparator
	 * @return java.lang.String
	 */
	public String getLineSeparator() {
		return this.lineSeparator;
	}

	/**
	 * getPathSeparator
	 * @return
	 */
	public String getPathSeparator() {
		return this.pathSeparator;
	}

	/**
	 * getTmpDirectory
	 * @return String
	 */
	public String getTmpDirectory() {
		return this.tmpDir;
	}

	/**
	 * getUserHomeDirectory
	 * @return String
	 */
	public String getUserHomeDirectory() {
		return this.userHome;
	}

	/**
	 * getCurrentDirectory
	 * @return String
	 */
	public String getCurrentDirectory() {
		return this.currDir;
	}

	/**
	 * getSVNAdminCommand
	 * @return
	 */
	public String getSVNAdminCommand() {
		if (osName.startsWith("WINDOWS") || osName.startsWith("OS/2")) {
			return "svnadmin.exe";
		}
		return "svnadmin";
	}

	/**
	 * getSVNServeCommand
	 * @return
	 */
	public String getSVNServeCommand() {
		if (osName.startsWith("WINDOWS") || osName.startsWith("OS/2")) {
			return "svnserve.exe";
		}
		return "svnserve";
	}

	/**
	 * getLogger
	 * @return LoggerImpl
	 */
	public Logger getLogger() {
		return logger;
	}

	/**
	 * getSystemUtilImpl
	 * @return SystemUtilImpl
	 */
	public SystemUtilImpl getSystemUtil() {
		if (utilImpl == null) {
			utilImpl = new SystemUtilImpl();
		}
		return utilImpl;
	}

	/**
	 * getDateUtil
	 * @return DateUtilImpl
	 */
	public DateUtilImpl getDateUtil() {
		if (dateUtilImpl == null) {
			dateUtilImpl = new DateUtilImpl();
		}
		return dateUtilImpl;
	}

	/**
	 * gc
	 */
	public String gc() {
		DecimalFormat df = new DecimalFormat("###,###,###.###");

		java.lang.Runtime rt = java.lang.Runtime.getRuntime();

		long total = rt.totalMemory();
		long free = rt.freeMemory();
		long used = total - free;
		float f = (float) used / (float) total;
		String msg = "Total: " + df.format(total / 1000000) + "MB ";
		msg += "[before] used: " + used + "(" + f * 100 + "%) ";

		rt.gc();

		free = rt.freeMemory();
		used = total - free;
		f = (float) used / (float) total;

		msg += "[after] used: " + used + "(" + f * 100 + "%) ";
		return msg;
	}
}
