package com.interpress_project.modernshare.client.view.wizard;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import com.interpress_project.modernshare.client.controller.model.RootStatus;

/**
 * @stereotype Wizard page3
 */
public class RegWizardPage3 extends WizardPage {
	private Button btnActiveYes, btnActiveNo, btnPc2host, btnHost2pc;
	private RootStatus status;
	private boolean bPc2host;

	/**
	 * RegWizardPage2
	 */
	public RegWizardPage3() {
		super("RegWizardPage3");

		setTitle("IvV̎w");
		setDescription("zbgVbgEtH_ɃIvVw肵܂B");
		setPageComplete(false);

		setStatus(RootStatus.active);
		setPc2host(true);
	}

	/**
	 * createControl
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;

		/**
		 * ANeBuɊւ`FbN{bNX
		 */
		{
			Group grpActive = new Group(composite, SWT.SHADOW_IN);
			GridData data = new GridData(GridData.FILL_HORIZONTAL);
			data.horizontalSpan = 9;
			data.verticalSpan = 9;
			grpActive.setLayoutData(data);

			grpActive.setText("Ď󋵂̐ݒ");
			grpActive.setLayout(new RowLayout(SWT.VERTICAL));

			Label label = new Label(grpActive, SWT.NONE);
			label.setText("zbgVbgEtH_ɑ΂鎩Ďw肵܂B\n");
			label.setLocation(20, 20);
			label.pack();

			btnActiveYes = new Button(grpActive, SWT.RADIO);
			btnActiveYes.setText("L");
			btnActiveYes.setToolTipText("zbgVbgEtH_̓vpeBŎw肳ꂽɏ]ăf[^Z^ԂŎ܂B");
			btnActiveYes.setSelection(false);
			btnActiveYes.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent selectionEvent) {
					setStatus(RootStatus.active);
					pageComplete();
				}
			});

			btnActiveNo = new Button(grpActive, SWT.RADIO);
			btnActiveNo.setText("");
			btnActiveNo.setToolTipText("zbgVbgEtH_ɑ΂鎩XV͍s܂B蓮Ńf[^Z^Ƃ̓sKv܂B");
			btnActiveNo.setSelection(false);
			btnActiveNo.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent selectionEvent) {
					setStatus(RootStatus.deactive);
					pageComplete();
				}
			});
		}
		/**
		 * XVɊւ`FbN{bNX
		 */
		{
			Group grpActive = new Group(composite, SWT.SHADOW_IN);
			GridData data = new GridData(GridData.FILL_HORIZONTAL);
			data.horizontalSpan = 9;
			data.verticalSpan = 9;
			grpActive.setLayoutData(data);

			grpActive.setText("|V[̐ݒ");
			grpActive.setLayout(new RowLayout(SWT.VERTICAL));

			Label label = new Label(grpActive, SWT.NONE);
			label.setText("zbgVbgEtH_ƃf[^Z^̓|V[ݒ肵܂B");
			label.setLocation(20, 20);
			label.pack();

			btnPc2host = new Button(grpActive, SWT.RADIO);
			btnPc2host.setText("zbgVbgtH_̓eŃf[^Z^XV(PC HotShot Folder -> Data Center)");
			btnPc2host.setToolTipText("ɃzbgVbgEtH_Ɋi[ꂽf[^Af[^Z^֍XV܂B");
			btnPc2host.setSelection(false);
			btnPc2host.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent selectionEvent) {
					setPc2host(true);
					pageComplete();
				}
			});
			btnPc2host.setSelection(true);

			btnHost2pc = new Button(grpActive, SWT.RADIO);
			btnHost2pc.setText("f[^Z^̓eŃzbgVbgtH_XV(DataCenter -> PC HotShot Folder)");
			btnHost2pc.setToolTipText("Ƀf[^Z^Ɋi[ꂽf[^ŃzbgVbgEtH_XV܂BzbgVbgEtH_Ǎp̋Lɂꍇɕ֗łB");
			btnHost2pc.setSelection(false);
			btnHost2pc.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent selectionEvent) {
					setPc2host(false);
					pageComplete();
				}
			});
		}
		// Register controls.
		setControl(composite);
	}

	/**
	 * setStatus
	 * @param status
	 */
	private void setStatus(RootStatus status) {
		this.status = status;
	}

	/**
	 * getStatus
	 * @return
	 */
	public RootStatus getStatus() {
		return status;
	}

	/**
	 * setPc2host
	 * @param b
	 */
	private void setPc2host(boolean b) {
		this.bPc2host = b;
	}

	/**
	 * getPc2host
	 * @return
	 */
	public boolean getPc2host() {
		return this.bPc2host;
	}

	/**
	 * pageIncomplete
	 * @param msg
	 */
	protected void pageIncomplete(String msg) {
		setErrorMessage(msg);
		setPageComplete(false);
	}

	/**
	 * pageComplete
	 */
	protected void pageComplete() {
		if ((btnActiveYes.getSelection() || btnActiveNo.getSelection())
		    && (btnPc2host.getSelection() || btnHost2pc.getSelection())) {
			setErrorMessage(null);
			setPageComplete(true);
		}
		else {
			setPageComplete(false);
		}
	}

	/**
	 * getNextPage
	 */
	public IWizardPage getNextPage() {
		RegConfirmPage regConfirmPage = (RegConfirmPage) getWizard().getPage("RegConfirmPage");
		regConfirmPage.setStatus(status);
		regConfirmPage.setPc2host(bPc2host);
		return super.getNextPage();
	}
}
