package com.interpress_project.modernshare.client.view.wizard;

import java.util.ArrayList;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;

/**
 * @stereotype Wizard page2
 */
public class RegWizardPage2 extends WizardPage {
	private final LocalModelManager lmmgr = LocalModelManager.getInstance();
	private final ArrayList<SVNRoot> tagNames;
	private final LocalRoot[] localRoots;
	private String tagName = "";

	/**
	 * RegWizardPage2
	 * @param tagNames
	 */
	public RegWizardPage2(ArrayList<SVNRoot> tagNames) {
		super("RegWizardPage2");

		this.setTitle("^O̎w");
		this.setDescription("o^zbgVbgEtH_ɔCӂ̃^O𖽖܂B\n" + "zbgVbgEtH_ɑΉf[^Z^̈̓^OŎʂ邱Ƃł܂B");
		this.setPageComplete(false);

		this.tagNames = tagNames;
		this.localRoots = lmmgr.getRootLineItem().getRoots();
	}

	/**
	 * createControl
	 * @param parent
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 2;
		layout.verticalSpacing = 9;

		Label label = new Label(composite, SWT.NULL);
		label.setText("^O(f[^Z^):");
		/**
		 * tH_pX̓̓{bNX
		 */
		final Text txtTag = new Text(composite, SWT.BORDER);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		txtTag.setLayoutData(gd);
		txtTag.setFocus();
		txtTag.addVerifyListener(new VerifyListener() {
			public void verifyText(VerifyEvent event) {
				switch (event.character) {
					default:
						pageComplete();
						break;

					case ' ': // space char
					case '*':
					case '?':
					case '&':
					case '/':
					case '\\':
					case '{':
					case '}':
					case '<':
					case '>':
					case '!':
					case '"':
					case '|':
					case '\'':
					case '`':
					case '+':
					case '^':
					case ':':
					case ';':
						pageIncomplete("ȕ" + event.character + "͂܂B");
						event.doit = false;
						break;
				}
			}
		});
		txtTag.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent event) {
				Text txtWidget = (Text) event.getSource();
				tagName = txtWidget.getText();
				if (findTagName(tagName)) {
					pageIncomplete(tagName + "͊Ƀf[^Z^ɑ݂Ă܂B̃^Ow肵܂B");
					return;
				}
				if (findLocalRoot(tagName)) {
					pageIncomplete(tagName + "͊Ƀ[J̃zbgVbgEXgɑ݂Ă܂B̖Ow肵܂B");
					return;
				}
				pageComplete();
			}
		});
		// Register controls.
		setControl(composite);
	}

	/**
	 * findTagName
	 * @param tagName
	 * @return
	 */
	private boolean findTagName(String tagName) {
		for (int i = 0; i < tagNames.size(); i++) {
			SVNRoot root = tagNames.get(i);
			if (root.getName().equalsIgnoreCase(tagName)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * findLocalRoot
	 * @param tagName
	 * @return
	 */
	private boolean findLocalRoot(String tagName) {
		for (int i = 0; i < localRoots.length; i++) {
			if (localRoots[i].getName().equalsIgnoreCase(tagName)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * getTagName
	 * 
	 * @return
	 */
	public String getTagName() {
		return tagName;
	}

	/**
	 * pageIncomplete
	 * @param msg
	 */
	protected void pageIncomplete(String msg) {
		setErrorMessage(msg);
		setPageComplete(false);
	}

	/**
	 * pageComplete
	 */
	protected void pageComplete() {
		setErrorMessage(null);
		setPageComplete(tagName.length() > 0);
	}

	/**
	 * getNextPage
	 *
	 * @return IWizardPage
	 */
	public IWizardPage getNextPage() {
		RegConfirmPage regConfirmPage = (RegConfirmPage) getWizard().getPage("RegConfirmPage");
		regConfirmPage.setTagName(this.getTagName());
		return super.getNextPage();
	}
}
