package com.interpress_project.modernshare.client.view.wizard;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 * @stereotype Wizard page1
 */
public class RegWizardPage1 extends WizardPage {
	protected String path = null;

	/**
	 * RegWizardPage1
	 */
	public RegWizardPage1() {
		super("RegWizardPage1");

		setTitle("zbgVbgEtH_̎w");
		setDescription("zbgVbgtH_ƂĊĎ郍[JtH_w肵܂B");
		setPageComplete(false);
	}

	/**
	 * Creates the controls for this page
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		Label label = new Label(composite, SWT.NULL);
		label.setText("zbgVbgEtH_:");
		/**
		 * tH_pX̓̓{bNX
		 */
		final Text txtPath = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		txtPath.setLayoutData(gd);
		txtPath.addModifyListener(new ModifyListener() {
			// Validate a file path.
			public void modifyText(ModifyEvent modifyEvent) {
				pageIncomplete(null);
				path = txtPath.getText();
				LocalModelManager localmgr = LocalModelManager.getInstance();
				if (localmgr.isPathOverwrapped(path)) {
					pageIncomplete("w肳ꂽ[JtH_͓o^ꂽzbgVbgEtH_ƏdĂ܂B\ñ[JtH_IĂB");
					return;
				}

				if (path.length() < 4) {
					String prefix = FilenameUtils.getPrefix(path);
					if (prefix.charAt(1) == ':') {
						pageIncomplete("hCuzbgVbgEtH_Ƃēo^邱Ƃ͂ł܂B\n[JtH_I܂B");
						return;
					}
				}

				if (path.startsWith("\\\\")) {
					pageIncomplete("UNCzbgVbgEtH_Ƃēo^邱Ƃ͂ł܂B\n[JtH_I܂B");
					return;
				}

				if (path.startsWith(System.getenv("ProgramFiles"))) {
					pageIncomplete("vOt@CtH_zbgVbgtH_Ƃēo^邱Ƃ͂ł܂B\n[JtH_I܂B");
					return;
				}

				if (path.startsWith(System.getenv("SystemRoot"))) {
					pageIncomplete("VXetH_zbgVbgEtH_Ƃēo^邱Ƃ͂ł܂B\n[JtH_I܂B");
					return;
				}
				pageComplete();
			}
		});

		/**
		 * tH_pX̃tH_w{^
		 */
		final Button button = new Button(composite, SWT.NONE);
		button.setText("...");
		button.setFocus();
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent selectionEvent) {
				ViewManager vmgr = ViewManager.getInstance();
				String path = vmgr.getDialogManager().createDirectoryDialog("zbgVbgEtH_̎w", "");
				if (path != null) {
					txtPath.setText(path);
				}
			}
		});
		setControl(composite);
	}

	/**
	 * pageIncomplete
	 * @param msg
	 */
	protected void pageIncomplete(String msg) {
		setErrorMessage(msg);
		setPageComplete(false);
	}

	/**
	 * pageComplete
	 */
	protected void pageComplete() {
		setErrorMessage(null);
		setPageComplete(path.length() > 0);
	}

	/**
	 * getPath
	 * @return
	 */
	public String getPath() {
		return path;
	}

	/**
	 * getNextPage
	 * 
	 * @return IWizardPage
	 */
	public IWizardPage getNextPage() {
		RegConfirmPage regConfirmPage = (RegConfirmPage) getWizard().getPage("RegConfirmPage");
		regConfirmPage.setPath(getPath());
		return super.getNextPage();
	}
}
