package com.interpress_project.modernshare.client.view.wizard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class NoticeFile {
	private SystemBase sb = SystemBase.getInstance();
	private String linesep = sb.getLineSeparator();
	private File file = null;
	private StringBuffer strbuf = new StringBuffer();

	/**
	 * NoticeFile
	 * @param path
	 * @param filter
	 * @param bROmode
	 */
	public NoticeFile(String path, String[] filter, boolean bROmode) {
		if (bROmode) {
			createROMessage(path, filter);
		}
		else {
			createRWMessage(path, filter);
		}

		path = path + "/" + AppKeys.NOTICEFILE;
		file = new File(path);
	}

	/**
	 * createRWMessage
	 * @param path
	 * @param filter
	 */
	private void createRWMessage(String path, String[] filter) {
		strbuf.append(path + "tH_ɂ" + linesep);
		strbuf.append(linesep);

		strbuf.append("̃tH_̓zbgVbgtH_ƂĊǗĂ܂BtH_zɒuꂽt@CtH_́AHotShotɂ" + "f[^Z^֒IɃobNAbv܂B"
		    + linesep);
		strbuf.append(linesep);

		strbuf.append("obNAbv珜Ot@CE[͈ȉ̒ʂłB" + linesep);
		strbuf.append(linesep);

		for (int i = 0; i < filter.length; i++) {
			strbuf.append("[(" + i + "): " + filter[i] + linesep);
		}
		strbuf.append(linesep);

		strbuf.append("ӓ_" + linesep);
		strbuf.append("̃tH_zɒu.svntH_́A΂ɍ폜ȂłB폜Ă܂ꍇɂHotShotɂ鎩Ď@\ȂȂ܂B" + linesep);
		strbuf.append("č폜Ă܂ꍇɂ́Aȉ̂悤ɕsĂB" + linesep);
		strbuf.append(linesep);

		strbuf.append("1. HotShot炱̃tH_ؒf܂B" + linesep);
		strbuf.append("@ؒfẴtH_̃f[^͂̂܂ܕێ܂B");
		strbuf.append(linesep);

		strbuf.append("2. ̃tH_Cӂ̖OɕύX܂B" + linesep);
		strbuf.append("@OύXăobNAbvĂ܂B");
		strbuf.append(linesep);

		strbuf.append("3. HotShot𗘗păf[^Z^`FbNAEgs܂B" + linesep);
		strbuf.append("@̃tH_Ɋ֘AÂꂽ^Ogpă`FbNAEgs܂BȂA`FbNAEg̍ۂɃ[JtH_AOύXÓÃtH_ɂ܂B" + linesep);
		strbuf.append(linesep);
	}

	/**
	 * createROMessage
	 * @param path
	 * @param filter
	 */
	private void createROMessage(String path, String[] filter) {
		strbuf.append(path + "tH_ɂ" + linesep);
		strbuf.append(linesep);

		strbuf.append("̃tH_̓zbgVbgǂݎpLtH_ƂĊǗĂ܂BtH_zɒuꂽt@CtH_́AHotShotɂ"
		    + "f[^Z^Ɋi[ꂽf[^ƒIɓ܂B" + "̍ۃ[JtH_ɒǉꂽf[^͍폜Ă܂܂̂łӂB" + linesep);
		strbuf.append(linesep);

		strbuf.append("obNAbv珜Ot@CE[͈ȉ̒ʂłB" + linesep);
		strbuf.append(linesep);

		for (int i = 0; i < filter.length; i++) {
			strbuf.append("[(" + i + "): " + filter[i] + linesep);
		}
		strbuf.append(linesep);

		strbuf.append("ӓ_" + linesep);
		strbuf.append("̃tH_zɒu.svntH_́A΂ɍ폜ȂłB폜Ă܂ꍇɂHotShotɂ鎩Ď@\ȂȂ܂B" + linesep);
		strbuf.append("č폜Ă܂ꍇɂ́Aȉ̂悤ɕsĂB" + linesep);
		strbuf.append(linesep);

		strbuf.append("1. HotShot炱̃tH_ؒf܂B" + linesep);
		strbuf.append("@ؒfẴtH_̃f[^͂̂܂ܕێ܂B");
		strbuf.append(linesep);

		strbuf.append("2. ̃tH_ACӂ̖OɕύX܂B" + linesep);
		strbuf.append("@OύXăobNAbvĂ܂B");
		strbuf.append(linesep);

		strbuf.append("3. HotShot𗘗păf[^Z^ǂݍ݃[hƂă`FbNAEgs܂B" + linesep);
		strbuf.append("@̃tH_Ɋ֘AÂꂽ^Ogpă`FbNAEgs܂BȂA`FbNAEg̍ۂɃ[JtH_AOύXÓÃtH_ɂ܂B" + linesep);
		strbuf.append(linesep);
	}

	/**
	 * create
	 */
	void create() {
		if (file.exists()) {
			file.delete();
		}
		FileWriter out = null;
		try {
			out = new FileWriter(file);
			out.write(strbuf.toString());
			out.flush();
			out.close();
		}
		catch (IOException ex) {
			sb.getLogger().error("Noticet@C̏oɎs܂B:" + file.getAbsolutePath(), ex);
			return;
		}
		return;
	}
}
