package com.interpress_project.modernshare.client.view.wizard;

import java.util.ArrayList;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;

/**
 * @stereotype Wizard page1
 */
public class CheckoutWizardPage1 extends WizardPage {
	private final LocalModelManager lmmgr = LocalModelManager.getInstance();
	private final ArrayList<SVNRoot> tagNames;
	private SVNRoot root = null;

	/**
	 * RegWizardPage1
	 */
	public CheckoutWizardPage1(ArrayList<SVNRoot> tagNames) {
		super("CheckoutWizardPage1");

		setTitle("f[^Z^̃[UtH_w");
		setDescription("f[^Z^Ƀ`FbNAEg\ȃ[UtH_(^O)܂Bȉ̃Xg`FbNAEg^OI܂B");
		setPageComplete(false);

		this.tagNames = tagNames;
	}

	/**
	 * createControl
	 */
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		layout.numColumns = 1;
		layout.verticalSpacing = 9;

		Label label = new Label(composite, SWT.NULL);
		label.setText("^OXgꗗ:");

		final List list = new List(composite, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
		GridData gd = new GridData(GridData.FILL_BOTH);
		list.setLayoutData(gd);

		for (int i = 0; i < tagNames.size(); i++) {
			SVNRoot root = tagNames.get(i);
			// Ƀ[J^[Qbgɑ݂^O̓`FbNAEgΏۂO
			if (lmmgr.isExistTagnameInRocal(root.getName())) {
				continue;
			}
			list.add(root.getName());
			list.setData(root.getName(), root);
		}

		list.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}

			/**
			 * widgetSelected
			 */
			public void widgetSelected(SelectionEvent arg0) {
				PageComplete();
				List list = (List) arg0.getSource();
				String[] tagname = list.getSelection();
				root = (SVNRoot) list.getData(tagname[0]);
			}
		});
		setControl(composite);
	}

	/**
	 * getSVNRoot
	 * @return
	 */
	public SVNRoot getSVNRoot() {
		return root;
	}

	/**
	 * PageComplete
	 */
	protected void PageComplete() {
		setErrorMessage(null);
		setPageComplete(true);
	}

	/**
	 * getNextPage
	 * @return IWizardPage
	 */
	public IWizardPage getNextPage() {
		CheckoutConfirmPage checkoutConfirmPage = (CheckoutConfirmPage) getWizard().getPage("CheckoutConfirmPage");
		checkoutConfirmPage.setTagName(root);
		return super.getNextPage();
	}
}
