package com.interpress_project.modernshare.client.view.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;

import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventSource;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class ChangePasswordWizard extends Wizard {
	private final SystemBase sb = SystemBase.getInstance();
	private final LogEventSource logEventSource = LogEventSource.getInstance();
	private ChgPwdWizardPage1 chgPwdWizardPage1 = new ChgPwdWizardPage1();
	private ORBManager orbmgr = null;

	/**
	 * ChangePasswordWizard
	 */
	public ChangePasswordWizard() {
		addPage(chgPwdWizardPage1);

		setNeedsProgressMonitor(true);
		setWindowTitle("pX[hύXEBU[h");
	}

	/**
	 * performFinish
	 */
	@Override
	public boolean performFinish() {
		// Thread definition
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
				orbmgr = ORBManager.getInstance();
				try {
					changePassword(monitor);
				}
				finally {
					monitor.done();
				}
			}
		};
		// Make the thread run.
		try {
			getContainer().run(true, false, op);
		}
		catch (InterruptedException ex) {
			sb.getLogger().error(ex);
			return false;
		}
		catch (InvocationTargetException ex) {
			ViewManager vmgr = ViewManager.getInstance();
			vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
			return false;
		}
		return true;
	}

	/**
	 * changePassword
	 * @param monitor
	 * @throws InvocationTargetException
	 */
	private void changePassword(IProgressMonitor monitor) throws InvocationTargetException {
		PropertyManager propmgr = PropertyManager.getInstance();
		String account = propmgr.getUsername();
		String password = propmgr.getPassword();

		monitor.beginTask("", 2);

		monitor.subTask("pX[h̕ύXs܂...");
		logEventSource.fireEvent(new LogEvent(this, "pX[h̕ύXs܂...", LogEventType.INFO));
		try {
			orbmgr.changePassword(account, password, account, chgPwdWizardPage1.getPassword());
			monitor.worked(1);
		}
		catch (Exception ex) {
			String msg = ex.getCause().getMessage();
			throw new InvocationTargetException(ex.getCause(), msg);
		}

		monitor.subTask("[J̃pX[h̕ύXĂ܂...");
		logEventSource.fireEvent(new LogEvent(this, "[J̃pX[h̕ύXĂ܂...", LogEventType.INFO));

		propmgr.setPassword(chgPwdWizardPage1.getPassword());
		try {
			propmgr.save();
			monitor.worked(1);
		}
		catch (IOException e) {
		}
	}
}
