package com.interpress_project.modernshare.client.view.preference;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Shell;

import com.interpress_project.modernshare.client.controller.model.PropertyManager;

public class ClientPreferenceDialog {

	/**
	 * @stereotype creates
	 */
	/*#com.interpress_project.modernshare.client.view.preference.PreferenceBasic Dependency20*/

	/**
	 * @stereotype creates
	 */
	/*#com.interpress_project.modernshare.client.view.PreferenceServer Dependency201*/

	/**
	 * @stereotype creates
	 */
	/*#com.interpress_project.modernshare.client.view.preference.PreferenceClient Dependency202*/

	private Shell shell;

	/**
	 * PreferenceDialog
	 */
	public ClientPreferenceDialog(Shell shell) {
		this.shell = shell;
	}

	/**
	 * run
	 */
	public void run() {
		PreferenceManager manager = new PreferenceManager();

		PreferenceNode basicNode1 = new PreferenceNode("Basic1", new PreferenceBasic());
		PreferenceNode basicNode2 = new PreferenceNode("Basic2", new PreferenceClient());
		manager.addToRoot(basicNode1);
		manager.addToRoot(basicNode2);

		PreferenceDialog dialog = new PreferenceDialog(shell, manager);

		PreferenceStore store = PropertyManager.getInstance();
		dialog.setPreferenceStore(store);

		dialog.open();
	}
}
