package com.interpress_project.modernshare.client.view.localfs;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.interpress_project.modernshare.client.controller.model.IFileItem;

public class FileTreeContentProvider implements ITreeContentProvider {
	/**
	 * getChildren
	 * @param element Object
	 * @return Object[]
	 */
	public Object[] getChildren(Object element) {
		Object[] kids = null;
		kids = ((IFileItem) element).getLocalItems();
		return kids == null ? new Object[0] : kids;
	}

	/**
	 * getElements
	 * @param element Object
	 * @return Object[]
	 */
	public Object[] getElements(Object element) {
		return getChildren(element);
	}

	/**
	 * hasChildren
	 * @param element Object
	 * @return boolean
	 */
	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}

	/**
	 * getParent
	 * @param element Object
	 * @return Object
	 */
	public Object getParent(Object element) {
		return ((IFileItem) element).getParent();
	}

	/**
	 * dispose
	 */
	public void dispose() {
	}

	/**
	 * inputChanged
	 * @param viewer Viewer
	 * @param old_input Object
	 * @param new_input Object
	 */
	public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
	}
}
