package com.interpress_project.modernshare.client.view.localfs;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class FileTableContentProvider implements IStructuredContentProvider {
	private final SystemBase sb = SystemBase.getInstance();
	private LocalSVNManager svnmgr = null;

	/**
	 * FileTableContentProvider
	 */
	public FileTableContentProvider() {
		svnmgr = LocalSVNManager.getInstance();
	}

	/**
	 * getElements
	 * @param element Object
	 * @return Object[]
	 */
	public Object[] getElements(Object element) {
		Object[] kids = null;

		String path = ((IFileItem) element).getAbsolutePath();
		try {
			kids = svnmgr.getSVNItems(path);
		}
		catch (InternalFailException ex) {
			ViewManager.getInstance().getDialogManager().createErrorMessageDialog(ex.getMessage());
			sb.getLogger().error(ex.getMessage());
			kids = null;
		}
		return kids == null ? new Object[0] : kids;
	}

	/**
	 * dispose
	 */
	public void dispose() {
	}

	/**
	 * inputChanged
	 * @param viewer Viewer
	 * @param old_object Object
	 * @param new_object Object
	 */
	public void inputChanged(Viewer viewer, Object old_object, Object new_object) {
	}
}
