package com.interpress_project.modernshare.client.view.localfs;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalFolder;

public class AllowOnlyFoldersFilter extends ViewerFilter {
	/**
	 * select
	 *
	 * @param viewer Viewer
	 * @param parent Object
	 * @param element Object
	 * @return boolean
	 */
	public boolean select(Viewer viewer, Object parent, Object element) {
		// Skip to display a leaf that indicates '.svn' folder.
		if (element instanceof LocalFolder) {
			String path = ((IFileItem) element).getName();
			if (path.equalsIgnoreCase(".svn")) {
				return false;
			}
		}
		return true;
	}
}
