package com.interpress_project.modernshare.client.view;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

import com.interpress_project.modernshare.client.controller.actions.AboutAction;
import com.interpress_project.modernshare.client.controller.actions.ChangePasswordAction;
import com.interpress_project.modernshare.client.controller.actions.CheckOutAction;
import com.interpress_project.modernshare.client.controller.actions.ExitAction;
import com.interpress_project.modernshare.client.controller.actions.HelpAction;
import com.interpress_project.modernshare.client.controller.actions.PropertyAction;
import com.interpress_project.modernshare.client.controller.actions.RegisterTargetAction;
import com.interpress_project.modernshare.client.controller.actions.StartupSyncAction;

public final class MfMenuBar extends MenuManager {
	/**
	 * MfMenuBar
	 * @param vmgr FrameManager
	 */
	public MfMenuBar(ViewManager vmgr) {
		super("");

		initComponents(vmgr);
	}

	/**
	 * initComponents
	 * 
	 * @param window ApplicationWindow
	 */
	private void initComponents(ViewManager vmgr) {
		/**
		 * File
		 */
		MenuManager fileMenu = new MenuManager("t@C(&F)");
		fileMenu.add(new PropertyAction(vmgr));
		fileMenu.add(new Separator());
		fileMenu.add(new ExitAction(vmgr));
		add(fileMenu);

		/**
		 * Tool
		 */
		MenuManager toolMenu = new MenuManager("c[(&T)");
		toolMenu.add(new RegisterTargetAction(vmgr));
		toolMenu.add(new CheckOutAction(vmgr));
		toolMenu.add(new StartupSyncAction(vmgr));		
		toolMenu.add(new Separator());
		toolMenu.add(new ChangePasswordAction(vmgr));
		add(toolMenu);

		/**
		 * Help
		 */
		MenuManager helpMenu = new MenuManager("wv(&H)");
		helpMenu.add(new HelpAction(vmgr));
		helpMenu.add(new Separator());
		helpMenu.add(new AboutAction(vmgr));
		add(helpMenu);
	}
}
