package com.interpress_project.modernshare.client.view;

import java.util.Date;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import com.interpress_project.modernshare.client.controller.actions.ActivateTargetAction;
import com.interpress_project.modernshare.client.controller.actions.ChangePasswordAction;
import com.interpress_project.modernshare.client.controller.actions.CheckOut2Action;
import com.interpress_project.modernshare.client.controller.actions.CheckOutAction;
import com.interpress_project.modernshare.client.controller.actions.DeActivateTargetAction;
import com.interpress_project.modernshare.client.controller.actions.DisableTargetAction;
import com.interpress_project.modernshare.client.controller.actions.ExportAction;
import com.interpress_project.modernshare.client.controller.actions.ImageFactory;
import com.interpress_project.modernshare.client.controller.actions.LocalExportAction;
import com.interpress_project.modernshare.client.controller.actions.LocalRefreshAction;
import com.interpress_project.modernshare.client.controller.actions.PropertyAction;
import com.interpress_project.modernshare.client.controller.actions.RefreshAction;
import com.interpress_project.modernshare.client.controller.actions.RegisterTargetAction;
import com.interpress_project.modernshare.client.controller.actions.RemoteDeleteAction;
import com.interpress_project.modernshare.client.controller.actions.SyncDataAction;
import com.interpress_project.modernshare.client.controller.actions.UnRegisterTargetAction;
import com.interpress_project.modernshare.client.controller.model.IFileItem;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalFile;
import com.interpress_project.modernshare.client.controller.model.LocalFolder;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.RemoteModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNFile;
import com.interpress_project.modernshare.client.controller.model.SVNFolder;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.RemoteViewEvent;
import com.interpress_project.modernshare.client.view.localfs.AllowOnlyFoldersFilter;
import com.interpress_project.modernshare.client.view.localfs.FileSorter;
import com.interpress_project.modernshare.client.view.localfs.FileTableContentProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTableLabelProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTreeContentProvider;
import com.interpress_project.modernshare.client.view.localfs.FileTreeLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteAllowOnlyFoldersFilter;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileSorter;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTableContentProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTableLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTreeContentProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteFileTreeLabelProvider;
import com.interpress_project.modernshare.client.view.remotefs.RemoteTreeFileSorter;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class MfContents {
	private final ViewManager vmgr;
	private final SystemBase sb = SystemBase.getInstance();

	private TreeViewer treeLocalViewer, treeRemoteViewer;
	private TableViewer tableLocalViewer, tableRemoteViewer;
	private Table tblAppLog;

	/**
	 * MfContents
	 * @param vmgr
	 * @param parent0
	 * @param type
	 */
	public MfContents(ViewManager vmgr, Composite parent0, int type) {
		this.vmgr = vmgr;

		// You should create dummy composite for make layout correct.
		Composite parent = new Composite(parent0, SWT.NONE);

		GridLayout gridLayout = new GridLayout(1, true);
		parent.setLayout(gridLayout);
		parent.setLayoutData(new GridData(GridData.FILL_BOTH));

		// cSashform
		SashForm sashform = new SashForm(parent, SWT.VERTICAL);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		sashform.setLayoutData(gridData);

		initFileViews(sashform);
		initLogView(sashform);

		sashform.setWeights(new int[] { 4, 2 });
	}

	/**
	 * initFileViews
	 * @param parent
	 */
	private void initFileViews(Composite parent) {
		Display display = parent.getDisplay();

		// CTabFolder view for Local/Remote FS view.
		CTabFolder tabFolder = new CTabFolder(parent, SWT.BORDER);
		tabFolder.setMaximizeVisible(true);
		tabFolder.setMinimizeVisible(true);
		tabFolder.setSimple(false);
		tabFolder.setTabHeight(24);

		// I^u̔wiFɃOf[Vݒ
		tabFolder.setSelectionBackground(new Color[] { display.getSystemColor(SWT.COLOR_TITLE_BACKGROUND),
		    display.getSystemColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT) }, new int[] { 90 }, true);

		// I^u̕Fݒ
		tabFolder.setSelectionForeground(display.getSystemColor(SWT.COLOR_WHITE));

		this.initLocalViewer(tabFolder);
		this.initRemoteViewer(tabFolder);
	}

	/**
	 * initLocalViewer
	 * @param parent
	 */
	private void initLocalViewer(CTabFolder tabFolder) {
		Display display = tabFolder.getDisplay();
		Font font = new Font(display, "MS UI Gothic", 9, SWT.NORMAL);

		// C[Wt̃^u쐬A[JFS Viewp
		CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);
		tabItem.setText("zbgVbgtH_([JPC)");
		tabItem.setImage(ImageFactory.getInstance().getImage("localpc"));

		SashForm sashform = new SashForm(tabFolder, SWT.HORIZONTAL);

		/**
		 * TreeViewer on the VierForm.
		 */
		ViewForm vfTreeView = new ViewForm(sashform, SWT.FLAT | SWT.BORDER);
		vfTreeView.setLayoutData(new GridData(GridData.FILL_BOTH));
		vfTreeView.setTopCenterSeparate(false);
		CLabel clabel = new CLabel(vfTreeView, SWT.NONE);
		clabel.setText("zbgVbgtH_");
		vfTreeView.setTopLeft(clabel);

		treeLocalViewer = new TreeViewer(vfTreeView, SWT.V_SCROLL | SWT.H_SCROLL);
		treeLocalViewer.getTree().setFont(font);
		treeLocalViewer.setContentProvider(new FileTreeContentProvider());
		treeLocalViewer.setLabelProvider(new FileTreeLabelProvider());
		treeLocalViewer.addFilter(new AllowOnlyFoldersFilter());
		treeLocalViewer.setSorter(new FileSorter());
		//		treeLocalViewer.setInput(LocalModelManager.getInstance().getRootLineItem());
		vfTreeView.setContent(treeLocalViewer.getTree());

		/**
		 * TreeViewł̃VONbNłTableView\
		 */
		treeLocalViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selected = (IStructuredSelection) event.getSelection();
				if (!selected.isEmpty()) {
					Object selectedObject = selected.getFirstElement();
					if (selectedObject instanceof LocalRoot) {
						return;
					}
					else if (selectedObject instanceof LocalFolder) {
					}
					else if (selectedObject instanceof LocalFile) {
					}
					tableLocalViewer.setInput(selectedObject);
				}
			}
		});

		/**
		 * LocalTreeView̃ReLXgj[ݒ
		 */
		MenuManager tv_menu_manager = new MenuManager();
		treeLocalViewer.getTree().setMenu(tv_menu_manager.createContextMenu(treeLocalViewer.getTree()));
		tv_menu_manager.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager menumgr) {
				Tree tree = treeLocalViewer.getTree();
				TreeItem[] treeItems = tree.getSelection();

				menumgr.setRemoveAllWhenShown(true);

				if (treeItems.length > 0) { // ^[Qbg݂ꍇ
					menumgr.add(new LocalRefreshAction(vmgr));
					menumgr.add(new Separator());

					IFileItem fileItem = (IFileItem) treeItems[0].getData();
					// Context menu for LocalRoot
					if (fileItem instanceof LocalRoot) {
						switch (((LocalRoot) fileItem).getStatus()) {
							case active: {
								menumgr.add(new DeActivateTargetAction(vmgr, fileItem.getAbsolutePath()));
								menumgr.add(new Separator());
								menumgr.add(new SyncDataAction(vmgr, (LocalRoot) fileItem));
								break;
							}

							case deactive: {
								menumgr.add(new ActivateTargetAction(vmgr, (LocalRoot) fileItem));
								menumgr.add(new Separator());
								menumgr.add(new SyncDataAction(vmgr, (LocalRoot) fileItem));
								break;
							}

							case disable: {
								break;
							}
						}
						menumgr.add(new DisableTargetAction(vmgr, fileItem.getAbsolutePath()));
						menumgr.add(new UnRegisterTargetAction(vmgr, fileItem.getAbsolutePath(), fileItem.getName()));
					}
					// Context menu for LocalFolder
					else if (fileItem instanceof LocalFolder) {
						menumgr.add(new LocalExportAction(vmgr, fileItem.getAbsolutePath()));
						menumgr.add(new ChangePasswordAction(vmgr));
					}
					// Context menu for LocalFile        
					else if (fileItem instanceof LocalFile) {
						menumgr.add(new LocalExportAction(vmgr, fileItem.getAbsolutePath()));
						menumgr.add(new PropertyAction(vmgr));
					}
				}
				else { // treeItems.length == 0 ^[Qbg݂Ȃꍇ
					menumgr.add(new RegisterTargetAction(vmgr));
					menumgr.add(new CheckOutAction(vmgr));
				}
			}
		});
		tableLocalViewer = new TableViewer(sashform, SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.H_SCROLL | SWT.VIRTUAL);
		tableLocalViewer.getTable().setFont(font);
		tableLocalViewer.getTable().setHeaderVisible(true);
		tableLocalViewer.setContentProvider(new FileTableContentProvider());
		tableLocalViewer.setLabelProvider(new FileTableLabelProvider());
		tableLocalViewer.setSorter(new FileSorter());

		// Type Name Size Author Revision LastChangedRevision LastChangedDate Host Path uuid
		TableColumn column = null;

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("O");
		column.setWidth(170);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.RIGHT);
		column.setText("TCY");
		column.setWidth(66);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("ύX");
		column.setWidth(76);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.RIGHT);
		column.setText("rW");
		column.setWidth(56);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.RIGHT);
		column.setText("rW(ŏIύX)");
		column.setWidth(116);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("XV");
		column.setWidth(172);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("i[zXg(f[^Z^)");
		column.setWidth(132);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("i[pX(f[^Z^)");
		column.setWidth(226);

		column = new TableColumn(tableLocalViewer.getTable(), SWT.LEFT);
		column.setText("UUID");
		column.setWidth(226);

		tabItem.setControl(sashform);

		sashform.setWeights(new int[] { 2, 3 });
		tabFolder.setSelection(0);
	}

	/**
	 * initRemoteViewer
	 * @param tabFolder
	 */
	private void initRemoteViewer(CTabFolder tabFolder) {
		Display display = tabFolder.getDisplay();
		Font font = new Font(display, "MS UI Gothic", 9, SWT.NORMAL);

		// C[Wt̃^u쐬A[gFS Viewp
		CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);
		tabItem.setText("zbgVbg|Wg(f[^Z^)");
		tabItem.setImage(ImageFactory.getInstance().getImage("remotepc"));

		SashForm sashform = new SashForm(tabFolder, SWT.HORIZONTAL);

		/**
		 * TreeViewer on the VierForm.
		 */
		ViewForm vfTreeView = new ViewForm(sashform, SWT.FLAT | SWT.BORDER);
		vfTreeView.setLayoutData(new GridData(GridData.FILL_BOTH));
		vfTreeView.setTopCenterSeparate(false);
		CLabel clabel = new CLabel(vfTreeView, SWT.NONE);
		clabel.setText("zbgVbg|Wg(f[^Z^)");
		vfTreeView.setTopLeft(clabel);

		treeRemoteViewer = new TreeViewer(vfTreeView, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		treeRemoteViewer.getTree().setFont(font);
		treeRemoteViewer.setContentProvider(new RemoteFileTreeContentProvider());
		treeRemoteViewer.setLabelProvider(new RemoteFileTreeLabelProvider());
		treeRemoteViewer.addFilter(new RemoteAllowOnlyFoldersFilter());
		treeRemoteViewer.setSorter(new RemoteTreeFileSorter());

		treeRemoteViewer.setInput(RemoteModelManager.getInstance().getRootLineItem());
		vfTreeView.setContent(treeRemoteViewer.getTree());

		/**
		 * Remote TreeViewł̃VONbN
		 */
		treeRemoteViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				TreeViewer tv = (TreeViewer) event.getSource();
				IStructuredSelection selected = (IStructuredSelection) event.getSelection();
				if (!selected.isEmpty()) {
					Object selectedObject = selected.getFirstElement();
					if (selectedObject instanceof SVNRoot) {
						return;
					}
					else if (selectedObject instanceof SVNFolder) {
						tv.expandToLevel(selectedObject, 1);
						tableRemoteViewer.setInput(selectedObject);
					}
					else if (selectedObject instanceof SVNFile) {
						tableRemoteViewer.setInput(selectedObject);
					}
				}
			}
		});

		/**
		 * RemoteTreeView̃ReLXgj[ݒ
		 */
		MenuManager tv_remote_menu_manager = new MenuManager();
		treeRemoteViewer.getTree().setMenu(tv_remote_menu_manager.createContextMenu(treeRemoteViewer.getTree()));
		tv_remote_menu_manager.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager menumgr) {
				Tree tree = treeRemoteViewer.getTree();
				TreeItem[] treeItems = tree.getSelection();

				ISVNFileItem[] items = new ISVNFileItem[treeItems.length];
				for (int i = 0; i < treeItems.length; i++) {
					items[i] = (ISVNFileItem) treeItems[i].getData();
				}

				menumgr.setRemoveAllWhenShown(true);

				if (items.length == 0) {
					menumgr.add(new RefreshAction(vmgr));
					return;
				}
				else if (items.length == 1) { // Single selection
					if (items[0] instanceof SVNRoot) {
						LocalModelManager lmmgr = LocalModelManager.getInstance();
						/**
						 * Check if it already checked out.
						 */
						if (lmmgr.canRegisterMore()) {
							if (lmmgr.isExistTagnameInRocal(((SVNRoot) items[0]).getName())) {
							}
							else {
								menumgr.add(new CheckOut2Action(vmgr, (SVNRoot) items[0]));
								menumgr.add(new Separator());
							}
						}
						menumgr.add(new ExportAction(vmgr, items[0]));
						menumgr.add(new RemoteDeleteAction(vmgr, items));
						menumgr.add(new Separator());
						menumgr.add(new RefreshAction(vmgr));
					}
					else { // SVNFolder or SVNFile
						menumgr.add(new ExportAction(vmgr, items[0]));
						menumgr.add(new RemoteDeleteAction(vmgr, items));
						menumgr.add(new Separator());
						menumgr.add(new RefreshAction(vmgr));
					}
				}
				else { // Multiple selection
					menumgr.add(new RemoteDeleteAction(vmgr, items));
				}
			}
		});
		tableRemoteViewer = new TableViewer(sashform, SWT.BORDER | SWT.FULL_SELECTION | SWT.VIRTUAL);
		tableRemoteViewer.getTable().setFont(font);
		tableRemoteViewer.getTable().setHeaderVisible(true);
		tableRemoteViewer.setContentProvider(new RemoteFileTableContentProvider());
		tableRemoteViewer.setLabelProvider(new RemoteFileTableLabelProvider());
		tableRemoteViewer.setSorter(new RemoteFileSorter());
		/**
		 * RemoteTableView̃ReLXgj[ݒ
		 */
		MenuManager tbl_remote_menu_manager = new MenuManager();
		tableRemoteViewer.getTable().setMenu(tbl_remote_menu_manager.createContextMenu(tableRemoteViewer.getTable()));
		tbl_remote_menu_manager.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager menumgr) {
				TableItem[] tableItems = tableRemoteViewer.getTable().getSelection();
				if (tableItems.length > 0) {
					ISVNFileItem item = (ISVNFileItem) tableItems[0].getData();
					menumgr.setRemoveAllWhenShown(true);
					menumgr.add(new ExportAction(vmgr, item));
				}
			}
		});

		TableColumn column = null;
		column = new TableColumn(tableRemoteViewer.getTable(), SWT.LEFT);
		column.setText("O");
		column.setWidth(180);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.RIGHT);
		column.setText("rW");
		column.setWidth(76);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.RIGHT);
		column.setText("rW(ŏIύX)");
		column.setWidth(120);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.LEFT);
		column.setText("ύX");
		column.setWidth(80);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.LEFT);
		column.setText("XV");
		column.setWidth(180);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.LEFT);
		column.setText("i[pX(f[^Z^)");
		column.setWidth(180);

		column = new TableColumn(tableRemoteViewer.getTable(), SWT.LEFT);
		column.setText("UUID");
		column.setWidth(240);

		sashform.setWeights(new int[] { 2, 3 });
		tabItem.setControl(sashform);
	}

	/**
	 * initLogView
	 * @param parent
	 */
	private void initLogView(Composite parent) {
		Display display = parent.getDisplay();
		/**
		 * TreeViewer on the VierForm.
		 */
		ViewForm vfLogView = new ViewForm(parent, SWT.FLAT | SWT.BORDER);
		vfLogView.setLayoutData(new GridData(GridData.FILL_BOTH));
		vfLogView.setTopCenterSeparate(false);
		CLabel clabel = new CLabel(vfLogView, SWT.NONE);
		clabel.setText("VXe񃍃O");
		vfLogView.setTopLeft(clabel);

		//		Font font = new Font(display, "MS UI Gothic", 9, SWT.NORMAL);

		tblAppLog = new Table(vfLogView, SWT.VIRTUAL | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL | SWT.READ_ONLY);
		//		tblAppLog.setFont(font);
		tblAppLog.setBackground(new Color(display, 255, 255, 255));
		tblAppLog.setHeaderVisible(true);
		tblAppLog.setLinesVisible(true);

		TableColumn column = null;
		column = new TableColumn(tblAppLog, SWT.CENTER);
		column.setText("");
		column.setWidth(22);
		column = new TableColumn(tblAppLog, SWT.LEFT);
		column.setText("");
		column.setWidth(192);
		column = new TableColumn(tblAppLog, SWT.LEFT);
		column.setText("Tv");
		column.setWidth(640);

		vfLogView.setContent(tblAppLog);
	}

	/**
	 * updateLocalViewer
	 * @param event
	 */
	public void updateLocalViewer(LocalViewEvent event) {
		Shell shell = vmgr.getShell();
		if (shell == null) {
			return;
		}
		shell.getDisplay().syncExec(new Runnable() {
			public void run() {
				treeLocalViewer.getTree().setRedraw(false);
				try {
					Object[] objs = treeLocalViewer.getExpandedElements();
					treeLocalViewer.setInput(LocalModelManager.getInstance().getRootLineItem());
					treeLocalViewer.setExpandedElements(objs);

					tableLocalViewer.setInput(null);
					tableLocalViewer.getTable().clearAll();
					tableLocalViewer.getTable().setItemCount(0);
				}
				finally {
					treeLocalViewer.getTree().setRedraw(true);
				}
			}
		});
	}

	/**
	 * updateRemoteViewer
	 * @param event
	 */
	public void updateRemoteViewer(RemoteViewEvent event) {
		Shell shell = vmgr.getShell();
		if (shell == null) {
			return;
		}
		shell.getDisplay().syncExec(new Runnable() {
			public void run() {
				treeRemoteViewer.getTree().setRedraw(false);
				try {
					treeRemoteViewer.setInput(RemoteModelManager.getInstance().getRootLineItem());

					treeRemoteViewer.expandToLevel(1);
					tableRemoteViewer.setInput(null);
					tableRemoteViewer.getTable().clearAll();
					tableRemoteViewer.getTable().setItemCount(0);
				}
				finally {
					treeRemoteViewer.getTree().setRedraw(true);
				}
			}
		});
	}

	/**
	 * updateAppLog
	 * @param event
	 */
	public void updateAppLog(final LogEvent event) {
		Shell shell = vmgr.getShell();
		if (shell == null) {
			return;
		}

		if (tblAppLog == null) {
			return;
		}

		shell.getDisplay().syncExec(new Runnable() {
			public void run() {
				int line_count = tblAppLog.getItemCount();
				if (line_count > 300) {
					tblAppLog.clear(0, 100);
				}

				switch (event.getLogEventType()) {
					default:
						String date = sb.getDateUtil().getDateTimeAsFullString(new Date());
						TableItem tableItem = new TableItem(tblAppLog, SWT.NONE);
						tableItem.setText(new String[] { "", date, event.getMessage() });

						if (event.getLogEventType() == LogEventType.ERROR) {
							tableItem.setImage(0, ImageFactory.getInstance().getImage("disable"));
							sb.getLogger().error(event.getMessage(), event.getException());
						}
						else {
							sb.getLogger().info(event.getMessage());
						}
						/**
						 * XN[ɂďɍŉs\
						 */
						tblAppLog.setTopIndex(tblAppLog.getItemCount() - 3);
						break;

					case CLEAR:
						tblAppLog.clearAll();
						tblAppLog.setItemCount(0);
						break;
				}
				tblAppLog.update();
			}
		});
	}
}
