package com.interpress_project.modernshare.client.view;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;

import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.PropertyManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.view.preference.ClientPreferenceDialog;
import com.interpress_project.modernshare.client.view.wizard.ChangePasswordWizard;
import com.interpress_project.modernshare.client.view.wizard.CheckoutWizard;
import com.interpress_project.modernshare.client.view.wizard.RemoteExportWizard;
import com.interpress_project.modernshare.client.view.wizard.LocalExportWizard;
import com.interpress_project.modernshare.client.view.wizard.RegisterTargetFolderWizard;

/**
 * @stereotype Manager
 */
public class DialogManager {
	/**
	 * @stereotype creates
	 */
	/*#com.interpress_project.modernshare.client.view.InitSyncModeDialog Dependency20*/

	private final ViewManager vmgr;
	private boolean bAnswer;

	/**
	 * DialogManager
	 * @param vmgr
	 */
	public DialogManager(ViewManager vmgr) {
		this.vmgr = vmgr;
	}

	/**
	 * createErrorMessageDialog
	 * @param desc
	 */
	public void createErrorMessageDialog(String desc) {
		final String _title = "G[bZ[W";
		final String _desc = desc;
		vmgr.getShell().getDisplay().syncExec(new Runnable() {
			public void run() {
				MessageDialog.openError(vmgr.getShell(), _title, _desc);
			}
		});
	}

	/**
	 * createInformationMessageDialog
	 * @param title
	 * @param desc
	 */
	public void createInformationMessageDialog(String title, String desc) {
		final String _title = title;
		final String _desc = desc;
		vmgr.getShell().getDisplay().asyncExec(new Runnable() {
			public void run() {
				MessageDialog.openInformation(vmgr.getShell(), _title, _desc);
			}
		});
	}

	/**
	 * createYesNoMessageDialog
	 * @param title String
	 * @param desc String
	 * @return boolean
	 */
	public boolean createYesNoMessageDialog(final String title, final String desc) {
		vmgr.getShell().getDisplay().syncExec(new Runnable() {
			public void run() {
				bAnswer = MessageDialog.openQuestion(vmgr.getShell(), title, desc);
			}
		});
		return bAnswer;
	}

	/**
	 * createDirectoryDialog
	 * @param title
	 * @param path
	 * @return
	 */
	public String createDirectoryDialog(String title, String path) {
		DirectoryDialog dialog = new DirectoryDialog(vmgr.getShell());
		dialog.setFilterPath(path);
		dialog.setMessage(title);
		return dialog.open();
	}

	/**
	 * createTargetFolderWizard
	 */
	public void createTargetFolderWizard(ArrayList<SVNRoot> list) {
		RegisterTargetFolderWizard regWizard = new RegisterTargetFolderWizard(list);
		WizardDialog dlg = new WizardDialog(vmgr.getShell(), regWizard);
		dlg.setPageSize(500, 190);
		dlg.open();
	}

	/**
	 * createCheckoutWizard
	 */
	public void createCheckoutWizard(ArrayList<SVNRoot> list) {
		CheckoutWizard checkoutWizard = new CheckoutWizard(list);
		WizardDialog dlg = new WizardDialog(vmgr.getShell(), checkoutWizard);
		dlg.setPageSize(500, 190);
		dlg.open();
	}

	/**
	 * createChangePasswordWizard
	 */
	public void createChangePasswordWizard() {
		ChangePasswordWizard chgPwdWizard = new ChangePasswordWizard();
		WizardDialog dlg = new WizardDialog(vmgr.getShell(), chgPwdWizard);
		dlg.setPageSize(500, 190);
		dlg.open();
	}

	/**
	 * createLocalExportWizard
	 * @param revlist
	 */
	public void createLocalExportWizard(ArrayList<ISVNFileItem> revlist) {
		LocalExportWizard wizard = new LocalExportWizard(revlist);
		WizardDialog dlg = new WizardDialog(vmgr.getShell(), wizard);
		dlg.setPageSize(500, 190);
		dlg.open();
	}

	/**
	 * createRemoteExportWizard
	 * @param revlist
	 */
	public void createRemoteExportWizard(ISVNFileItem item) {
		RemoteExportWizard wizard = new RemoteExportWizard(item);
		WizardDialog dlg = new WizardDialog(vmgr.getShell(), wizard);
		dlg.setPageSize(500, 190);
		dlg.open();
	}

	/**
	 * createPreferenceDialog
	 */
	public void createPreferenceDialog() {
		ClientPreferenceDialog dlg = new ClientPreferenceDialog(vmgr.getShell());
		dlg.run();
	}

	/**
	 * openSaveDialog
	 * @return
	 */
	public String openSaveDialog(String baseName) {
		FileDialog dlg = new FileDialog(vmgr.getShell(), SWT.SAVE);
		dlg.setFileName(baseName);
		dlg.setFilterNames(new String[] { "All Files (*.*)" });
		String fileName = dlg.open();
		return fileName;
	}

	/**
	 * createSyncModeDialog
	 */
	public int createSyncModeDialog() {
		SyncModeDialog dlg = new SyncModeDialog(vmgr);
		int result = dlg.open();
		return result;
	}

	/**
	 * SyncModeDialog class
	 * @author ys
	 */
	private class SyncModeDialog extends TitleAreaDialog {
		private Button b1, b2;

		/**
		 * SyncModeDialog
		 * @param vmgr
		 */
		public SyncModeDialog(ViewManager vmgr) {
			super(vmgr.getShell());
		}

		/**
		 * createDialogArea
		 */
		protected Control createDialogArea(Composite composite) {
			PropertyManager propmgr = PropertyManager.getInstance();

			setTitle("f[^Z^Ƃ̓");
			setMessage("zbgVbgtH_ƃf[^Z^Ԃœs܂B|V[w肵ĂB", IMessageProvider.NONE);

			GridLayout layout = new GridLayout();
			composite.setLayout(layout);
			layout.numColumns = 1;
			layout.marginTop = 4;
			layout.marginLeft = 4;
			layout.marginRight = 4;

			final Group g = new Group(composite, SWT.SHADOW_ETCHED_IN);
			GridData gd = new GridData(GridData.FILL_HORIZONTAL);
			g.setLayoutData(gd);
			g.setLayout(new RowLayout(SWT.VERTICAL));

			g.setText("|V[̑I");
			b1 = new Button(g, SWT.RADIO);
			b1.setText("zbgVbgtH_̓eŃf[^Z^XV(PC HotShot Folder -> Data Center)");
			b2 = new Button(g, SWT.RADIO);
			b2.setText("f[^Z^̓eŃzbgVbgtH_XV(DataCenter -> PC HotShot Folder)");
			if (propmgr.isPc2Host()) {
				b1.setSelection(true);
			}
			else {
				b2.setSelection(true);
			}
			return composite;
		}

		/**
		 * canHandleShellCloseEvent
		 */
		protected boolean canHandleShellCloseEvent() {
			return false;
		}

		/**
		 * buttonPressed
		 */
		protected void buttonPressed(int buttonId) {
			PropertyManager propmgr = PropertyManager.getInstance();

			if (IDialogConstants.OK_ID == buttonId) {
				if (b1.getSelection()) {
					propmgr.setPc2Host(true);
					setReturnCode(0);
				}
				else {
					propmgr.setPc2Host(false);
					setReturnCode(1);
				}
			}
			else {
				setReturnCode(-1);
			}
			close();
		}
	}
}
