package com.interpress_project.modernshare.client.events;

import java.util.Enumeration;
import java.util.Vector;

/**
 * Cxg\[XEIuWFNg Cxg\[XbN܂܃CxgXiĂяoƁA
 * CxgXȉɂĂ̓fbhbNĂ܂B̖
 * ȉ̓_lŉB
 * - CxgXi̓o^E폜synchronizedԂōsB
 * - CxgXiɑ΂ĂяosynchronizedłȂԂōsB
 * - CxgXiǗĂlistenersɃANZX鎞synchronizedgp
 *   IuWFNgbN邱Ƃ
 * - Cxg̑Mlisteners𕡐̂ɑ΂čsƁB
 *
 * ̎ȂCxgXiԃXbhLĂÃXbh̃IuWFNg
 * gp邱(IuWFNg̓o^폜܂߂)ubN邱Ƃ͂ȂȂB
 *
 * @stereotype Event source
 */
public class LogEventSource {
	/**
	 * @stereotype uses
	 */
	/*#com.interpress_project.modernshare.client.events.LogEvent Dependency20*/

	private static Vector<ILogEventListener> listeners = new Vector<ILogEventListener>(3);
	/**
	 * Holds singleton instance
	 */
	private static LogEventSource instance;

	/**
	 * CommandEventSource
	 */
	private LogEventSource() {
	}

	/**
	 * addEventListener
	 * @param listener
	 */
	public void addEventListener(ILogEventListener listener) {
		if (listeners.contains(listener)) {
			return;
		}
		listeners.addElement(listener);
	}

	/**
	 * removeEventListener
	 * @param listener
	 */
	public void removeEventListener(ILogEventListener listener) {
		listeners.removeElement(listener);
	}

	/**
	 * fireEvent CxgXiǗĂlisteners_ɃANZX鎞 synchronizedgp
	 * IuWFNgbN邱ƂƁACxg̑Mlisteners𕡐̂ɑ΂čsƁB
	 * XiǗĂVectoraddElement\bhremoveElement\bhA
	 * clone\bhsynchronizedɂȂĂ邽߁ArsKvȂB
	 *
	 * @param eventName String
	 */
	public void fireEvent(LogEvent event) {
		Vector vector = (Vector) listeners.clone();
		Enumeration enumeration = vector.elements();
		while (enumeration.hasMoreElements()) {
			ILogEventListener l = (ILogEventListener) enumeration.nextElement();
			l.EventArrived(event);
		}
	}

	/**
	 * Returns the singleton instance.
	 @return	the singleton instance
	 */
	static public LogEventSource getInstance() {
		if (instance == null) {
			instance = new LogEventSource();
		}
		return instance;
	}
}
