package com.interpress_project.modernshare.client.controller.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SVNItemCache {
	private final PropertyManager propmgr = PropertyManager.getInstance();

	/**
	 * @link aggregation
	 * @associates com.interpress_project.modernshare.client.controller.model.ISVNFileItem
	 * @directed directed
	 * @supplierCardinality 0..*
	 */
	private List<ISVNFileItem> arrList = null;

	/**
	 * SVNItemCache
	 */
	public SVNItemCache() {
		arrList = Collections.synchronizedList(new ArrayList<ISVNFileItem>(propmgr.getMaxCache() + 1));
	}

	/**
	 * addSVNFileItem
	 * @param item
	 */
	public void addSVNFileItem(ISVNFileItem item) {
		int sz = arrList.size();
		if (sz > (propmgr.getMaxCache() - 1)) {
			arrList.remove(sz - 1);
		}
		arrList.add(item);
	}

	/**
	 * getSVNFileItem
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ArrayList<ISVNFileItem> getSVNFileItem() {
		Collections.sort(arrList, new Comparator() {
			public int compare(Object element0, Object element1) {
				long r0 = ((ISVNFileItem) element0).getRevision();
				long r1 = ((ISVNFileItem) element1).getRevision();
				return r0 > r1 ? 0 : 1;
			}
		});
		return new ArrayList<ISVNFileItem>(arrList);
	}

	/**
	 * isChached
	 * @param item
	 * @return
	 */
	public boolean isCached(ISVNFileItem item) {
		for (int i = 0; i < arrList.size(); i++) {
			ISVNFileItem l = arrList.get(i);
			if ((l.getRevision() == item.getRevision()) && (l.getLastChangedRevision() == item.getLastChangedRevision())) {
				return true;
			}
		}
		return false;
	}
}
