package com.interpress_project.modernshare.client.controller.model;

import java.util.ArrayList;
import java.util.Date;

import com.interpress_project.modernshare.client.controller.delegate.RemoteSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public class SVNFile implements ISVNFileItem {
	private String name;
	private long fileSize;
	private String author;
	private long revision;
	private long lastChangedRevision;
	private Date lastChangedDate;
	private String url;
	private String uuid;

	public SVNFile(String name, long fileSize, String author, Date lastChangedDate, long revision,
	    long lastChangedRevision, String url, String uuid) {
		this.name = name;
		this.fileSize = fileSize;
		this.author = author;
		this.lastChangedDate = lastChangedDate;
		this.revision = revision;
		this.lastChangedRevision = lastChangedRevision;
		this.url = url;
		this.uuid = uuid;
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return fileSize;
	}

	/**
	 * getLastChangedDate
	 */
	public Date getLastChangedDate() {
		return lastChangedDate;
	}

	/**
	 * getLastChanagedRevision
	 */
	public long getLastChangedRevision() {
		return lastChangedRevision;
	}

	/**
	 * getLastCommitAuthor
	 */
	public String getLastCommitAuthor() {
		return author;
	}

	/**
	 * getName
	 */
	public String getName() {
		return name;
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return false;
	}

	/**
	 * getSVNItems
	 */
	public ISVNFileItem[] getSVNItems() {
		return null;
	}

	/**
	 * getRevisionInfo
	 * @throws InternalFailException 
	 */
	public ISVNFileItem[] getRevisionInfo() throws InternalFailException {
		ArrayList<ISVNFileItem> list = null;
		RemoteSVNManager svnmgr = RemoteSVNManager.getInstance();

		list = svnmgr.getRevisionInfo(url);

		return list.toArray(new ISVNFileItem[list.size()]);
	}

	/**
	 * getRevision
	 */
	public long getRevision() {
		return revision;
	}

	/**
	 * getURL
	 */
	public String getURL() {
		return url;
	}

	/**
	 * getUUID
	 */
	public String getUUID() {
		return uuid;
	}
}
