package com.interpress_project.modernshare.client.controller.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SVNCacheManager {
	/**
	 * @link aggregation 
	 * @associates com.interpress_project.modernshare.client.controller.model.SVNItemCache
	 * @directed directed
	 * @supplierCardinality 0..*
	 */
	private Map<String, SVNItemCache> mapSVNItemCache = null;

	/**
	 * SVNCacheManager
	 */
	public SVNCacheManager() {
		mapSVNItemCache = Collections.synchronizedMap(new HashMap<String, SVNItemCache>());
	}

	/**
	 * addSVNFileItem
	 * @param item
	 */
	public void addSVNFileItem(ISVNFileItem item) {
		String url = item.getURL();
		SVNItemCache cache = mapSVNItemCache.get(url);
		if (cache == null) {
			cache = new SVNItemCache();
		}
		cache.addSVNFileItem(item);
		mapSVNItemCache.put(url, cache);
	}

	/**
	 * getSVNFileItems
	 * @param uuid
	 * @return
	 */
	public ArrayList<ISVNFileItem> getSVNFileItems(String url) {
		SVNItemCache cache = mapSVNItemCache.get(url);
		if (cache == null) {
			return null;
		}
		return cache.getSVNFileItem();
	}

	/**
	 * isCached
	 * @param item
	 * @return
	 */
	public boolean isCached(ISVNFileItem item) {
		String url = item.getURL();
		SVNItemCache cache = mapSVNItemCache.get(url);
		if (cache == null) {
			return false;
		}
		return cache.isCached(item);
	}

	/**
	 * getCurrentCacheSize
	 * @return
	 */
	public int getCurrentCacheSize() {
		return mapSVNItemCache.size();
	}
}
