package com.interpress_project.modernshare.client.controller.model;

/**
 * Represents a singleton.
 * @stereotype Singleton factory
 */
public class RemoteModelManager {
	private RemoteRootLineItem lineitem = null;

	/**
	 * Holds singleton instance
	 */
	private static RemoteModelManager instance;

	/**
	 * prevents instantiation
	 */
	protected RemoteModelManager() {
		lineitem = new RemoteRootLineItem();
	}

	/**
	 * dispose
	 */
	void dispose() {
		return;
	}

	/**
	 * getRootLineItem
	 * @return
	 */
	public RemoteRootLineItem getRootLineItem() {
		return lineitem;
	}

	/**
	 * addRoot
	 * @param item
	 */
	public void addRoot(SVNRoot item) {
		if (item.isDirectory()) {
			lineitem.addRoot((SVNRoot) item);
		}
	}

	/**
	 * clear
	 */
	public void clear() {
		lineitem.clear();
	}

	/**
	 * Returns the singleton instance.
	 @return	the singleton instance
	 */
	static public RemoteModelManager getInstance() {
		if (instance == null) {
			instance = new RemoteModelManager();
		}
		return instance;
	}
}
