package com.interpress_project.modernshare.client.controller.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

import com.interpress_project.modernshare.AppKeys;

/**
 * @stereotype lineitem
 */

public class LocalRootLineItem implements IFileItem {
	/**
	 * @associates com.interpress_project.modernshare.client.controller.model.LocalRoot
	 * @directed directed
	 * @link aggregation
	 * @supplierCardinality 0..*
	 */
	Hashtable<String, LocalRoot> htTargetFolders = null;

	/**
	 * LocalRootLineItem
	 */
	public LocalRootLineItem() {
		htTargetFolders = new Hashtable<String, LocalRoot>();
	}

	/**
	 * addRoot
	 * @param root
	 */
	public void addRoot(LocalRoot root) {
		htTargetFolders.put(root.getAbsolutePath(), root);
	}

	/**
	 * canRegisterMore
	 * @return
	 */
	public boolean canRegisterMore() {
		LocalRoot[] roots = this.getRoots();
		if (roots.length >= AppKeys.MAX_TARGETS) {
			return false;
		}
		return true;
	}

	/**
	 * removeRoot
	 * @param path
	 */
	public void removeRoot(String path) {
		LocalRoot root = getRoot(path);
		if (root == null) {
			return;
		}
		htTargetFolders.remove(path);
	}

	/**
	 * removeRootByTagname
	 * @param tagname
	 */
	public void removeRootByTagname(String tagname) {
		Enumeration<LocalRoot> e = htTargetFolders.elements();
		while (e.hasMoreElements()) {
			LocalRoot root = e.nextElement();
			if (root.getName().equals(tagname)) {
				htTargetFolders.remove(root.getAbsolutePath());
				break;
			}
		}
	}

	/**
	 * getRoots
	 * @return
	 */
	public LocalRoot[] getRoots() {
		ArrayList<LocalRoot> arrayList = new ArrayList<LocalRoot>();
		/**
		 * zbgVbgEtH_폜Ă邩Ȃ̂
		 * ŐV󋵂mF邱ƁB
		 */
		checkDisableStatus();

		Enumeration<LocalRoot> enumeration = htTargetFolders.elements();
		while (enumeration.hasMoreElements()) {
			LocalRoot item = enumeration.nextElement();
			arrayList.add(item);
		}
		return arrayList.toArray(new LocalRoot[arrayList.size()]);
	}

	/**
	 * getActiveRoots
	 * @return
	 */
	public LocalRoot[] getActiveRoots() {
		ArrayList<LocalRoot> arrayList = new ArrayList<LocalRoot>();
		/**
		 * zbgVbgEtH_폜Ă邩Ȃ̂
		 * ŐV󋵂mF邱ƁB
		 */
		checkDisableStatus();

		Enumeration<LocalRoot> enumeration = htTargetFolders.elements();
		while (enumeration.hasMoreElements()) {
			LocalRoot item = enumeration.nextElement();
			switch (item.getStatus()) {
				default:
					break;

				case active:
					arrayList.add(item);
					break;
			}
		}
		return arrayList.toArray(new LocalRoot[arrayList.size()]);
	}

	/**
	 * checkDisableStatus
	 * o^ꂽLocalRoot̍ŐVXe[^XmF鏈B
	 */
	private void checkDisableStatus() {
		Enumeration<LocalRoot> enumeration = htTargetFolders.elements();
		while (enumeration.hasMoreElements()) {
			LocalRoot item = enumeration.nextElement();
			if (!new File(item.getAbsolutePath()).exists()) {
				item.setStatus(RootStatus.disable);
			}
		}
	}

	/**
	 * isExistTagnameInRocal
	 * @param tagName
	 * @return
	 */
	public boolean isExistTagnameInRocal(String tagName) {
		LocalRoot[] localRoots = getRoots();
		for (int i = 0; i < localRoots.length; i++) {
			if (localRoots[i].getName().equalsIgnoreCase(tagName)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * getLocalRoot
	 * @param path
	 * @return
	 */
	public LocalRoot getRoot(String path) {
		return htTargetFolders.get(path);
	}

	/**
	 * getAbsolutePath
	 */
	public String getAbsolutePath() {
		return null;
	}

	/**
	 * getFilesize
	 */
	public long getFilesize() {
		return 0;
	}

	/**
	 * getLocalItems
	 */
	public IFileItem[] getLocalItems() {
		return getRoots();
	}

	/**
	 * getName
	 */
	public String getName() {
		return null;
	}

	/**
	 * getParent
	 */
	public IFileItem getParent() {
		return null;
	}

	/**
	 * isDirectory
	 */
	public boolean isDirectory() {
		return false;
	}

	/**
	 * isExist
	 */
	public boolean isExist() {
		return true;
	}

	/**
	 * dispose
	 */
	public void dispose() {
		LocalRoot[] roots = this.getRoots();
		for (int i = 0; i < roots.length; i++) {
			roots[i].dispose();
		}
	}
}
