package com.interpress_project.modernshare.client.controller.model;

import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;

public class LocalRoot extends LocalFolder implements FileSystemEventListener {
	private FsWatcherManager fsmgr = null;
	private String tagName;
	private RootStatus status;
	private boolean bPc2host, bDirty;

	/**
	 * LocalRoot
	 * @param path
	 * @param tagName
	 * @param status
	 * @param bPc2host
	 */
	public LocalRoot(String path, String tagName, RootStatus status, boolean bPc2host) {
		super(path);

		fsmgr = new FsWatcherManager(path);

		this.tagName = tagName;
		this.setStatus(status);
		this.setPc2host(bPc2host);
		this.setDirty(false);
	}

	/**
	 * getName
	 */
	public String getName() {
		return tagName;
	}

	/**
	 * getStatus
	 * @param status
	 */
	public void setStatus(RootStatus status) {
		this.status = status;

		if (RootStatus.active == status) {
			fsmgr.addFileSystemListener(this);
			fsmgr.start();
		}
		else {
			fsmgr.removeFileSystemListener(this);
			fsmgr.stop();
		}
	}

	/**
	 * getStatus
	 * @return
	 */
	public RootStatus getStatus() {
		return this.status;
	}

	/**
	 * setPc2Host
	 * @param b
	 */
	public void setPc2host(boolean b) {
		this.bPc2host = b;
	}

	/**
	 * getPc2host
	 * @return
	 */
	public boolean getPc2host() {
		return this.bPc2host;
	}

	/**
	 * setDirty
	 * @param b
	 */
	public void setDirty(boolean b) {
		this.bDirty = b;
	}

	/**
	 * isDirty
	 * @return
	 */
	public boolean isDirty() {
		return this.bDirty;
	}

	/**
	 * handle
	 */
	public void handle(FileSystemEvent event) {
		setDirty(true);
	}

	/**
	 * startFsWatcher
	 */
	public void startFsWatcher() {
		fsmgr.start();
	}

	/**
	 * stopFsWatcher
	 */
	public void stopFsWatcher() {
		fsmgr.stop();
	}

	/**
	 * dispose
	 */
	public void dispose() {
		this.fsmgr.dispose();
	}
}
