package com.interpress_project.modernshare.client.controller.model;

import java.util.Date;

import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;

public interface ISVNFileItem {
	/**
	 * getSVNItems
	 * @return
	 */
	ISVNFileItem[] getSVNItems()throws InternalFailException;

	/**
	 * getRevisionInfo
	 * @return
	 */
	ISVNFileItem[] getRevisionInfo() throws InternalFailException;

	/**
	 * getName
	 * @return
	 */
	String getName();

	/**
	 * isDirectory
	 * @return
	 */
	boolean isDirectory();

	/**
	 * getFilesize
	 * @return
	 */
	long getFilesize();

	/**
	 * getLastCommitAuthor
	 * @return
	 */
	String getLastCommitAuthor();

	/**
	 * getRevision
	 * @return
	 */
	long getRevision();

	/**
	 * getLastChangedRevision
	 * @return
	 */
	long getLastChangedRevision();

	/**
	 * getLastChangedDate
	 * @return
	 */
	Date getLastChangedDate();

	/**
	 * getURL
	 * @return
	 */
	String getURL();

	/**
	 * getUUID
	 * @return
	 */
	String getUUID();
}
