package com.interpress_project.modernshare.client.controller.command;

import java.io.File;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class SyncLocalWithRemoteCommand extends ISVNCommand {
	private final SystemBase sb = SystemBase.getInstance();
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private File rootpath;
	private LocalRoot localRoot;

	/**
	 * SyncRemoteCommand
	 * @param path
	 */
	public SyncLocalWithRemoteCommand(LocalRoot localRoot) {
		super();

		this.rootpath = new File(localRoot.getAbsolutePath());
		this.localRoot = localRoot;
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		logEventSource.fireEvent(new LogEvent(this, "f[^Z^Ɋi[ꂽf[^" + rootpath + "XV܂...", LogEventType.INFO));

		localRoot.stopFsWatcher(); // XV̓t@CVXeĎ~
		try {
			/**
			 * Main process
			 */
			_execute();

			/**
			 * Refresh local views.
			 */
			cmdmgr.addCommand(factory.createLocalRefreshCommand());
		}
		finally {
			localRoot.startFsWatcher();
			sb.getLogger().debug(sb.gc()); // Gabage collection.
		}
		logEventSource.fireEvent(new LogEvent(this, rootpath + "ւ̍XVI܂B", LogEventType.INFO));
	}

	/**
	 * _execute
	 * @throws CommandException
	 */
	public void _execute() throws CommandException {
		sb.getLogger().debug("Enter SyncLocalWithRemoteCommand()._execute");

		// Make a connection.
		try {
			svnmgr.connect();
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}

		// SVN cleanup
		try {
			svnmgr.cleanupFiles(rootpath);
		}
		catch (InternalFailException ex) {
			sb.getLogger().warn("SVNN[Abvs܂Bp܂B", ex);
			// Fall throught...
		}

		try {
			svnmgr.syncLocalFilesWithRemote(rootpath);
		}
		catch (InternalFailException ex) {
			throw new CommandException(ex);
		}
		sb.getLogger().debug("Leave SyncLocalWithRemoteCommand()._execute");
	}
}
