package com.interpress_project.modernshare.client.controller.command;

import java.util.ArrayList;
import java.util.Hashtable;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.ORBManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.NoPermissionException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.UnknownHostException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * [g̃^Ol[擾āA[J̃^Ol[XVB
 * ^Ol[[JɂA[gɖꍇ̓[Ĵ̂폜B 
 * @author ys
 */
public class SyncListCommand extends ISVNCommand {
	private final SystemBase sb = SystemBase.getInstance();
	private final ORBManager orbmgr = ORBManager.getInstance();
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();

	/**
	 * SyncListCommand
	 */
	public SyncListCommand() {
		super();
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		sb.getLogger().debug("Enter SyncListCommand().execute");
		/**
		 * Refresh SVN port information.
		 */
		try {
			orbmgr.updateSVNServerInfo();
		}
		catch (NoPermissionException ex) {
			throw new CommandException(ex);
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}
		catch (UnknownHostException ex) {
			throw new CommandException(ex);
		}

		/**
		 * get tagName list from remote.
		 */
		try {
			svnmgr.connect();
		}
		catch (ConnectionFailException ex) {
			throw new CommandException(ex);
		}

		ArrayList<SVNRoot> tagnames = null;
		try {
			tagnames = svnmgr.getTagNames();
		}
		catch (InternalFailException ex) {
			throw new CommandException(ex);
		}

		/**
		 * [gƃ[J̃XgrÂB
		 */
		ArrayList<String> arrLocal = new ArrayList<String>();
		Hashtable<String, String> htRemote = new Hashtable<String, String>();

		LocalModelManager lmmgr = LocalModelManager.getInstance();
		LocalRoot[] roots = lmmgr.getRootLineItem().getRoots();
		for (int i = 0; i < roots.length; i++) {
			arrLocal.add(roots[i].getName());
		}

		for (int i = 0; i < tagnames.size(); i++) {
			ISVNFileItem item = tagnames.get(i);
			htRemote.put(item.getName(), item.getName());
		}

		for (int i = 0; i < arrLocal.size(); i++) {
			String locTagname = arrLocal.get(i);
			String rmtTagname = htRemote.get(locTagname);
			if (rmtTagname == null) {
				lmmgr.removeRootByTagname(locTagname);
			}
		}
		sb.getLogger().debug("Leave SyncListCommand().execute");
	}
}
