package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.events.*;
import com.interpress_project.modernshare.client.view.ViewManager;

public abstract class ISVNCommand {
	protected static LogEventSource logEventSource;
	protected static GUIEventSource guiEventSource;
	protected static LocalViewEventSource localViewEventSource;
	protected static RemoteViewEventSource remoteViewEventSource;

	/**
	 * ISVNCommand
	 */
	public ISVNCommand() {
		logEventSource = LogEventSource.getInstance();
		logEventSource.addEventListener(ViewManager.getInstance());

		guiEventSource = GUIEventSource.getInstance();
		guiEventSource.addEventListener(ViewManager.getInstance());

		localViewEventSource = LocalViewEventSource.getInstance();
		localViewEventSource.addEventListener(ViewManager.getInstance());

		remoteViewEventSource = RemoteViewEventSource.getInstance();
		remoteViewEventSource.addEventListener(ViewManager.getInstance());
	}

	/**
	 * execute
	 * @throws CommandException
	 */
	public abstract void execute() throws CommandException;
}
