package com.interpress_project.modernshare.client.controller.command;

import java.io.File;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.ipcommon.SystemBase;

public class CheckoutCommand extends ISVNCommand {
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
	private final LocalModelManager lmmgr = LocalModelManager.getInstance();
	private final SystemBase sb = SystemBase.getInstance();
	private File path;
	private SVNRoot root;
	private RootStatus status;
	private boolean bPc2host;

	/**
	 * CheckoutCommand
	 * @param path
	 * @param root
	 * @param status
	 * @param bPc2host
	 */
	public CheckoutCommand(String path, SVNRoot root, RootStatus status, boolean bPc2host) {
		super();

		this.path = new File(path);
		this.root = root;
		this.status = status;
		this.bPc2host = bPc2host;
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		String svnurl = root.getURL();

		try {
			svnmgr.checkoutFiles(path, svnurl);
		}
		catch (InternalFailException ex) {
			throw new CommandException(ex);
		}
		lmmgr.addRoot(path.getAbsolutePath(), root.getName(), status, bPc2host);

		sb.getLogger().debug(sb.gc()); // Gabage collection.							
	}
}
