package com.interpress_project.modernshare.client.controller.command;

import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;

public class ActiveTargetCommand extends ISVNCommand {
	private String path;
	private RootStatus status;

	/**
	 * ActiveTargetCommand
	 * @param path
	 * @param status
	 */
	public ActiveTargetCommand(String path, RootStatus status) {
		super();

		this.path = path;
		this.status = status;
	}

	/**
	 * execute
	 */
	public void execute() throws CommandException {
		LocalModelManager lmmgr = LocalModelManager.getInstance();
		lmmgr.setStatus(path, status);
	}
}
