package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.model.LocalRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 * @stereotype action
 */
public class SyncDataAction extends ActionAdaptor {
	private final SystemBase sb = SystemBase.getInstance();
	private final ViewManager vmgr;
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();
	private LocalRoot localRoot = null;

	/**
	 * SyncDataAction
	 * @param vmgr
	 * @param item
	 */
	public SyncDataAction(final ViewManager vmgr, LocalRoot localRoot) {
		setText("f[^̋(&C)");
		setToolTipText("HotShottH_ƃf[^Z^Ԃŋs܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("sync"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.localRoot = localRoot;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		int mode = -1;

		try {
			taskmgr.stop();

			boolean bResult = vmgr.getDialogManager().createYesNoMessageDialog("f[^̓mF",
			  "zbgVbgtH_" + localRoot.getAbsolutePath() + "ɑ΂铯s܂B");
			if (bResult == false) {
				return;
			}

			if (localRoot.getPc2host()) {
				mode = vmgr.getDialogManager().createSyncModeDialog();
				if (mode == -1) { // Selected CANCEL.
					return;
				}
			}
			else {
				mode = 1; // m[hHost2PcłΓRemote->PĈ݁B_CAOsvB
			}

			/**
			 * [J^[QbgXg𓯊
			 */
			cmdmgr.execCommand(factory.createSyncListCommand());

			switch (mode) {
				default: {
					return;
				}
				case 0: { // PC -> Remote
					sb.getLogger().debug("PC->Remote: [JŃ[gXV");
					cmdmgr.execCommand(factory.createSyncRemoteWithLocalCommand(localRoot));
					break;
				}
				case 1: { // Remote -> PC
					sb.getLogger().debug("Remote->PC: [gŃ[JXV");
					cmdmgr.execCommand(factory.createSyncLocalWithRemoteCommand(localRoot));
					break;
				}
			}
		}
		catch (CommandException ex) {
			String msg = ex.getCause().getMessage();
			logEventSource.fireEvent(new LogEvent(this, msg, LogEventType.ERROR, ex));
			vmgr.getDialogManager().createErrorMessageDialog(msg);
		}
		finally {
			taskmgr.start();
		}
	}
}
