package com.interpress_project.modernshare.client.controller.actions;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class RegisterTargetAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public RegisterTargetAction(ViewManager vmgr) {
		setText("zbgVbgtH_o^(&R)");
		setToolTipText("[JtH_zbgVbgtH_Ƃēo^܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("register"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		ArrayList<SVNRoot> list = null;

		try {
			taskmgr.stop();

			logEventSource.fireEvent(new LogEvent(this, LogEventType.CLEAR));

			if (LocalModelManager.getInstance().canRegisterMore() == false) {
				vmgr.getDialogManager().createErrorMessageDialog(
				  "ǗtH_͍ő" + AppKeys.MAX_TARGETS + "܂œo^ł܂BȏǗtH_o^邱Ƃ͂ł܂B");
				return;
			}

			/**
			 * ǂ̏Wizardy[Wł͏stbNRXgN^
			 * createControl()̂݁ÂɂŃXg擾鑼ɎiȂB
			 */
			MessageDialog dlg = new MessageDialog(vmgr.getShell(), "^Öꗗ擾", null, "f[^Z^^Öꗗ擾Ă܂B΂炭҂...",
			  MessageDialog.INFORMATION, new String[] {}, 0);
			dlg.setBlockOnOpen(false);
			try {
				dlg.open();

				try {
					svnmgr.connect();
				}
				catch (ConnectionFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}

				try {
					list = svnmgr.getTagNames();
				}
				catch (InternalFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}
			}
			finally {
				dlg.close();
			}
			vmgr.getDialogManager().createTargetFolderWizard(list);
		}
		finally {
			taskmgr.start();
		}
	}
}
