package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class RefreshAction extends ActionAdaptor {
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();

	/**
	 * ConnectRemote
	 * @param vmgr
	 */
	public RefreshAction(ViewManager vmgr) {
		setText("tbV(&R)");
		setToolTipText("f[^Z^Ɋi[郊\[XXgXV܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("refresh"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
	}

	/**
	 * run
	 */
	public void run() {
		cmdmgr.addCommand(factory.createRemoteRefreshCommand());
	}
}
