package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class LocalRefreshAction extends ActionAdaptor {
	private final SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
	private final SVNCommandFactory factory = SVNCommandFactory.getInstance();

	/**
	 * LocalRefreshAction
	 * @param vmgr
	 */
	public LocalRefreshAction(ViewManager vmgr) {
		setText("tbV(&R)");
		setToolTipText("[J\[XtbV܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("refresh"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
	}

	/**
	 * run
	 */
	public void run() {
		sb.getLogger().debug("Enter LocalRefreshAction().");
		
		cmdmgr.addCommand(factory.createLocalRefreshCommand());
	}
}
