package com.interpress_project.modernshare.client.controller.actions;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.ISVNFileItem;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class LocalExportAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();
	private String fileName;

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public LocalExportAction(ViewManager vmgr, String fileName) {
		setText("f[^̎o(&X)");
		setToolTipText("f[^Z^Ɋi[ꂽf[^o܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("export"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.fileName = fileName;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		ArrayList<ISVNFileItem> revlist = new ArrayList<ISVNFileItem>();

		try {
			taskmgr.stop();

			logEventSource.fireEvent(new LogEvent(this, LogEventType.CLEAR));

			/**
			 * ǂ̏Wizardy[Wł͏stbNRXgN^
			 * createControl()̂݁ÂɂŃXg擾鑼ɎiȂB
			 */
			MessageDialog dlg = new MessageDialog(vmgr.getShell(), "rW̎擾", null,
			  "f[^Z^烊rWXg擾Ă܂B΂炭҂...", MessageDialog.INFORMATION, new String[] {}, 0);
			dlg.setBlockOnOpen(false);
			try {
				dlg.open();

				try {
					svnmgr.connect();
				}
				catch (ConnectionFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}

				try {
					revlist = svnmgr.getRevisionInfo(fileName);
				}
				catch (InternalFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}
			}
			finally {
				dlg.close();
			}
			vmgr.getDialogManager().createLocalExportWizard(revlist);
		}
		finally {
			taskmgr.start();
		}
	}
}
