package com.interpress_project.modernshare.client.controller.actions;

import org.eclipse.swt.program.Program;

import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
final public class HelpAction extends ActionAdaptor {
	@SuppressWarnings("unused")
	private final ViewManager vmgr;

	public HelpAction(ViewManager vmgr) {
		setText("wv(&H)");
		setEnabled(true);
		setToolTipText("wv\܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("help"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
	}

	/**
	 * run
	 */
	public void run() {
		sb.getLogger().debug("Enter run() in HelpAction.");
		String fsep = sb.getFileSeparator();

		Program program = Program.findProgram("pdf");
		if (program == null) {
			vmgr.getDialogManager().createErrorMessageDialog(
			  "HTMLuEUݒ肳ĂȂ߃wvEy[W\邱Ƃł܂B" + "CXg[tH_zɂdocsQƂB");
			return;
		}
		String path = sb.getCurrentDirectory() + fsep + "docs" + fsep + "ClientGuide.pdf";
		program.execute(path);
	}
}
