package com.interpress_project.modernshare.client.controller.actions;

import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
final public class ExitAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private boolean bTerminated = false;

	/**
	 * ExitAction
	 * @param vmgr
	 */
	public ExitAction(ViewManager vmgr) {
		setText("I(&X)");
		setToolTipText("AvP[VI܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("exit"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
	}

	/**
	 * run
	 * vmgr.close()s邱ƁBe}l[Wdispose()ViewManager
	 * InhŎs邱ƁB
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		taskmgr.stop();

		bTerminated = vmgr.getDialogManager().createYesNoMessageDialog("AvP[V̏ImF", "HotShot ClientI܂B낵ł?");
		if (bTerminated) {
			vmgr.close(); // Kick ViewManager.dispose();
		}
		else {
			taskmgr.start();
		}
	}

	/**
	 * isTerminated
	 * @return
	 */
	public boolean isTerminated() {
		return bTerminated;
	}
}
