package com.interpress_project.modernshare.client.controller.actions;

import java.io.File;
import java.util.ArrayList;

import com.interpress_project.modernshare.client.controller.command.ISVNCommand;
import com.interpress_project.modernshare.client.controller.command.SVNCommandFactory;
import com.interpress_project.modernshare.client.controller.command.SVNCommandManager;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.command.exceptions.CommandException;
import com.interpress_project.modernshare.client.controller.delegate.SVNFolderUtil;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.DeleteFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.RootStatus;
import com.interpress_project.modernshare.client.events.LocalViewEvent;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.events.ViewEventType;
import com.interpress_project.modernshare.client.view.ViewManager;
import com.interpress_project.modernshare.ipcommon.SystemBase;

/**
 *@stereotype action
 */
public final class DisableTargetAction extends ActionAdaptor {
	private SystemBase sb = SystemBase.getInstance();
	private ViewManager vmgr;
	private String path;

	/**
	 * DislableTargetAction
	 * @param vmgr
	 * @param path
	 */
	public DisableTargetAction(ViewManager vmgr, String path) {
		setText("zbgVbgtH_̓o^(&U)");
		setToolTipText("zbgVbgtH_̓o^܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("unconnected"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
		this.path = path;
	}

	/**
	 * run
	 */
	public void run() {
		sb.getLogger().debug("Enter DisableTargetAction()");

		TaskManager taskmgr = TaskManager.getInstance();
		try {
			taskmgr.stop();

			boolean bAnswer = vmgr.getDialogManager().createYesNoMessageDialog("zbgVbgtH_̓o^",
			  "zbgVbgtH_" + path + "̓o^܂B(f[^Z^̃f[^͍폜܂B)");
			if (bAnswer == false) {
				return;
			}
			/**
			 * Make disable the target.
			 */
			SVNCommandManager cmdmgr = SVNCommandManager.getInstance();
			SVNCommandFactory factory = SVNCommandFactory.getInstance();
			ISVNCommand command = factory.createActiveTargetCommand(path, RootStatus.deactive);
			try {
				cmdmgr.execCommand(command);
			}
			catch (CommandException e) {
			}
			logEventSource.fireEvent(new LogEvent(this, "zbgVbgtH_" + path + "Ǘ폜܂B҂...", LogEventType.INFO));

			/**
			 * Remove the files...
			 */
			if (new File(path).exists()) {
				SVNFolderUtil futil = SVNFolderUtil.getInstance();
				ArrayList<File> list = futil.getSVNDirListInTarget(new File(path));
				try {
					futil.deleteFiles(list);
				}
				catch (DeleteFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					return;
				}
			}

			/**
			 * Remove the target in LocalView.
			 */
			LocalModelManager lmmgr = LocalModelManager.getInstance();
			lmmgr.removeRoot(path);

			localViewEventSource.fireEvent(new LocalViewEvent(this, ViewEventType.REFRESH));
			logEventSource.fireEvent(new LogEvent(this, "zbgVbgtH_" + path + "Ǘ폜܂B", LogEventType.INFO));
		}
		finally {
			taskmgr.start();
		}
	}
}
