package com.interpress_project.modernshare.client.controller.actions;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;

import com.interpress_project.modernshare.AppKeys;
import com.interpress_project.modernshare.client.controller.command.TaskManager;
import com.interpress_project.modernshare.client.controller.delegate.LocalSVNManager;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.ConnectionFailException;
import com.interpress_project.modernshare.client.controller.delegate.exceptions.InternalFailException;
import com.interpress_project.modernshare.client.controller.model.LocalModelManager;
import com.interpress_project.modernshare.client.controller.model.SVNRoot;
import com.interpress_project.modernshare.client.events.LogEvent;
import com.interpress_project.modernshare.client.events.LogEventType;
import com.interpress_project.modernshare.client.view.ViewManager;

/**
 *@stereotype action
 */
public final class CheckOutAction extends ActionAdaptor {
	private final ViewManager vmgr;
	private final LocalSVNManager svnmgr = LocalSVNManager.getInstance();

	/**
	 * RegisterTargetAction
	 * @param vmgr
	 */
	public CheckOutAction(ViewManager vmgr) {
		setText("f[^Z^zbgVbgEtH_쐬(&C)");
		setToolTipText("f[^Z^烍[JPCɃzbgVbgEtH_쐬܂B");
		try {
			setImageDescriptor(ImageFactory.getInstance().getImageDescriptor("chkout"));
		}
		catch (Exception ex) {
			sb.getLogger().fatal("\[Xݒ̃G[܂B", ex);
			System.exit(-1);
		}
		this.vmgr = vmgr;
	}

	/**
	 * run
	 */
	public void run() {
		TaskManager taskmgr = TaskManager.getInstance();
		ArrayList<SVNRoot> list = null;

		try {
			taskmgr.stop();

			if (LocalModelManager.getInstance().canRegisterMore() == false) {
				vmgr.getDialogManager().createErrorMessageDialog(
				  "ǗłtH_͍ő" + AppKeys.MAX_TARGETS + "ƂȂ܂BȏtH_`FbNAEg邱Ƃ͂ł܂B");
				return;
			}

			MessageDialog dlg = new MessageDialog(vmgr.getShell(), "^OXg̎擾", null,
			  "f[^Z^^OXg擾Ă܂B΂炭҂...", MessageDialog.INFORMATION, new String[] {}, 0);
			dlg.setBlockOnOpen(false);
			try {
				dlg.open();

				try {
					svnmgr.connect();
				}
				catch (ConnectionFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}

				try {
					list = svnmgr.getTagNames();
				}
				catch (InternalFailException ex) {
					logEventSource.fireEvent(new LogEvent(this, ex.getMessage(), LogEventType.ERROR, ex));
					vmgr.getDialogManager().createErrorMessageDialog(ex.getMessage());
					return;
				}
			}
			finally {
				dlg.close();
			}

			boolean bExist = false;
			LocalModelManager lmmgr = LocalModelManager.getInstance();
			for (int i = 0; i < list.size(); i++) {
				SVNRoot root = list.get(i);
				if (lmmgr.isExistTagnameInRocal(root.getName())) {
					continue;
				}
				bExist = true;
			}

			if (bExist == false) {
				sb.getLogger().info("f[^Z^ɂ̓`FbNAEg\ȃ^O݂Ă܂B");
				vmgr.getDialogManager().createInformationMessageDialog("`FbNAEg̊mF", "f[^Z^ɂ̓`FbNAEg\ȃ^O݂Ă܂B");
				return;
			}
			logEventSource.fireEvent(new LogEvent(this, LogEventType.CLEAR));

			vmgr.getDialogManager().createCheckoutWizard(list);
		}
		finally {
			sb.getLogger().debug(sb.gc()); // Gabage collection.
			taskmgr.start();
		}
	}
}
